/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices;

import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import net.algart.executors.modules.opencv.util.OTools;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgcodecs;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Size;
import org.bytedeco.opencv.opencv_core.UMat;

public final class SimpleJavaCPPOpenCV {
    private static final int KERNEL_SIZE = 119;
    private static final int N = 1;

    public static void main(String[] args) throws Exception {
        System.out.println("OpenCL existence: " + opencv_core.haveOpenCL());
        System.out.println("OpenCL usage: " + opencv_core.useOpenCL());
        System.out.println("OpenCL enabled: " + OTools.isGPUOptimizationEnabled());
        if (args.length == 0) {
            System.out.printf("Usage: %s source_image%n", SimpleJavaCPPOpenCV.class.getName());
            return;
        }
        String sourceFile = args[0];
        if (!Files.exists(Paths.get(sourceFile, new String[0]), new LinkOption[0])) {
            throw new FileNotFoundException(sourceFile);
        }
        for (int testCount = 0; testCount < 10; ++testCount) {
            int k;
            Mat mat = opencv_imgcodecs.imread((String)sourceFile);
            opencv_imgproc.resize((Mat)mat, (Mat)mat, (Size)new Size(2000, 2000));
            System.out.println("Test #" + testCount);
            Mat result = mat.clone();
            Size ksize = new Size(119, 119);
            opencv_imgproc.GaussianBlur((Mat)mat, (Mat)result, (Size)ksize, (double)0.0);
            long t1 = System.nanoTime();
            for (int k2 = 0; k2 < 1; ++k2) {
                opencv_imgproc.GaussianBlur((Mat)mat, (Mat)result, (Size)ksize, (double)0.0);
            }
            long t2 = System.nanoTime();
            System.out.printf("Mat %s (at 0x%x) blurred by %dx%d in %.3f ms%n", mat, mat.address(), ksize.width(), ksize.height(), (double)(t2 - t1) * 1.0E-6 / 1.0);
            UMat umat = mat.getUMat(0x3000000);
            UMat uresult = umat.clone();
            opencv_imgproc.GaussianBlur((UMat)uresult, (UMat)uresult, (Size)ksize, (double)0.0);
            t1 = System.nanoTime();
            for (int k3 = 0; k3 < 1; ++k3) {
                opencv_imgproc.GaussianBlur((UMat)umat, (UMat)uresult, (Size)ksize, (double)0.0);
            }
            t2 = System.nanoTime();
            System.out.printf("UMat %s (at 0x%x) blurred by %dx%d in %.3f ms%n", umat, umat.address(), ksize.width(), ksize.height(), (double)(t2 - t1) * 1.0E-6 / 1.0);
            opencv_imgcodecs.imwrite((String)(sourceFile + ".javacpp.ublur.png"), (Mat)OTools.toMat((UMat)uresult));
            t1 = System.nanoTime();
            UMat umatClone = umat.clone();
            t2 = System.nanoTime();
            System.out.printf("UMat %s (at 0x%x) is cloned in %.3f ms%n", umatClone, umatClone.address(), (double)(t2 - t1) * 1.0E-6);
            opencv_imgproc.cvtColor((Mat)mat, (Mat)mat, (int)6);
            t1 = System.nanoTime();
            for (k = 0; k < 1; ++k) {
                opencv_imgproc.GaussianBlur((Mat)mat, (Mat)result, (Size)ksize, (double)0.0);
            }
            t2 = System.nanoTime();
            System.out.printf("Mat %s (at 0x%x) blurred by %dx%d in %.3f ms%n", mat, mat.address(), ksize.width(), ksize.height(), (double)(t2 - t1) * 1.0E-6 / 1.0);
            umat = mat.getUMat(0x3000000);
            uresult = umat.clone();
            t1 = System.nanoTime();
            for (k = 0; k < 1; ++k) {
                opencv_imgproc.GaussianBlur((UMat)umat, (UMat)uresult, (Size)ksize, (double)0.0);
            }
            t2 = System.nanoTime();
            System.out.printf("UMat %s (at 0x%x) blurred by %dx%d in %.3f ms%n", umat, umat.address(), ksize.width(), ksize.height(), (double)(t2 - t1) * 1.0E-6 / 1.0);
            opencv_imgcodecs.imwrite((String)(sourceFile + ".javacpp.ublur.gray.png"), (Mat)uresult.getMat(0x3000000));
            System.err.println("Start gc...");
            for (k = 0; k < 5; ++k) {
                System.gc();
            }
            System.err.println("End gc");
        }
    }
}

