/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import net.algart.executors.api.data.SMat;
import net.algart.executors.modules.core.matrices.conversions.ChangePrecision;
import net.algart.executors.modules.opencv.util.O2SMat;
import net.algart.io.MatrixIO;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;
import org.bytedeco.opencv.global.opencv_imgcodecs;
import org.bytedeco.opencv.opencv_core.Mat;

public final class ChangePrecisionTest {
    public static void main(String[] args) throws IOException {
        Mat mat;
        SMat m;
        if (args.length < 2) {
            System.out.printf("Usage: %s source_image elementType%n", ChangePrecisionTest.class.getName());
            return;
        }
        Path sourceFile = Paths.get(args[0], new String[0]);
        String elementType = args[1];
        MultiMatrix2D image = MultiMatrix.of2DRGBA((List)MatrixIO.readImage((Path)sourceFile));
        try (ChangePrecision cc = new ChangePrecision();){
            cc.setElementType(elementType);
            image = cc.process((MultiMatrix)image);
            MatrixIO.writeImage((Path)Paths.get(String.valueOf(sourceFile) + "." + elementType + ".aa.png", new String[0]), (List)image.allChannelsInRGBAOrder());
            m = new SMat();
            m.setTo((MultiMatrix)image);
            mat = O2SMat.toMat((SMat)m);
            System.out.printf("OpenCV mat: %s%n", mat);
            opencv_imgcodecs.imwrite((String)(String.valueOf(sourceFile) + "." + elementType + ".opencv.png"), (Mat)mat);
            mat.convertTo(mat, 0);
            System.out.printf("OpenCV mat reduced to bytes: %s%n", mat);
            opencv_imgcodecs.imwrite((String)(String.valueOf(sourceFile) + "." + elementType + ".to_byte.opencv.png"), (Mat)mat);
            cc.setElementType(Byte.TYPE);
            image = cc.process((MultiMatrix)image);
        }
        MatrixIO.writeImage((Path)Paths.get(String.valueOf(sourceFile) + ".aa.byte.png", new String[0]), (List)image.allChannelsInRGBAOrder());
        m.setTo((MultiMatrix)image);
        mat = O2SMat.toMat((SMat)m);
        System.out.printf("OpenCV byte mat: %s%n", mat);
        opencv_imgcodecs.imwrite((String)(String.valueOf(sourceFile) + ".byte.opencv.png"), (Mat)mat);
        mat.convertTo(mat, 2);
        System.out.printf("OpenCV short mat: %s%n", mat);
        opencv_imgcodecs.imwrite((String)(String.valueOf(sourceFile) + ".byte.to_short.opencv.png"), (Mat)mat);
        mat.convertTo(mat, 0);
        System.out.printf("OpenCV byte mat: %s%n", mat);
        opencv_imgcodecs.imwrite((String)(String.valueOf(sourceFile) + ".byte.to_short.to_byte.opencv.png"), (Mat)mat);
        mat.convertTo(mat, 4);
        System.out.printf("OpenCV int mat: %s%n", mat);
        opencv_imgcodecs.imwrite((String)(String.valueOf(sourceFile) + ".byte.to_int.opencv.png"), (Mat)mat);
        mat.convertTo(mat, 0);
        System.out.printf("OpenCV byte mat: %s%n", mat);
        opencv_imgcodecs.imwrite((String)(String.valueOf(sourceFile) + ".byte.to_int.to_byte.opencv.png"), (Mat)mat);
    }
}

