/*
 * Decompiled with CFR 0.152.
 */
package jep;

import java.io.File;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import jep.ClassEnquirer;
import jep.JepException;
import jep.SubInterpreter;
import jep.SubInterpreterOptions;

public class JepConfig {
    protected boolean interactive = false;
    protected StringBuilder includePath = null;
    protected ClassLoader classLoader = null;
    protected ClassEnquirer classEnquirer = null;
    protected OutputStream redirectStdout = null;
    protected OutputStream redirectStderr = null;
    protected Set<String> sharedModules = null;
    protected SubInterpreterOptions subInterpOptions = SubInterpreterOptions.legacy();

    public JepConfig setIncludePath(String string) {
        this.includePath = null;
        if (string != null) {
            this.includePath = new StringBuilder(string);
        }
        return this;
    }

    public JepConfig addIncludePaths(String ... stringArray) {
        if (this.includePath == null) {
            this.includePath = new StringBuilder();
        }
        for (String string : stringArray) {
            if (this.includePath.length() > 0) {
                this.includePath.append(File.pathSeparator);
            }
            this.includePath.append(string);
        }
        return this;
    }

    public JepConfig setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public JepConfig setClassEnquirer(ClassEnquirer classEnquirer) {
        this.classEnquirer = classEnquirer;
        return this;
    }

    public JepConfig redirectStdout(OutputStream outputStream) {
        this.redirectStdout = outputStream;
        return this;
    }

    public JepConfig redirectStdErr(OutputStream outputStream) {
        this.redirectStderr = outputStream;
        return this;
    }

    public JepConfig setSharedModules(Set<String> set) {
        this.sharedModules = set;
        return this;
    }

    public JepConfig addSharedModules(String ... stringArray) {
        if (this.sharedModules == null) {
            this.sharedModules = new HashSet<String>();
        }
        Collections.addAll(this.sharedModules, stringArray);
        return this;
    }

    public JepConfig setSubInterpreterOptions(SubInterpreterOptions subInterpreterOptions) {
        this.subInterpOptions = subInterpreterOptions;
        return this;
    }

    public SubInterpreter createSubInterpreter() throws JepException {
        return new SubInterpreter(this);
    }

    public String toString() {
        return "JepConfig [interactive=" + this.interactive + ", includePath=" + String.valueOf(this.includePath) + ", classLoader=" + String.valueOf(this.classLoader) + ", classEnquirer=" + String.valueOf(this.classEnquirer) + ", redirectStdout=" + String.valueOf(this.redirectStdout) + ", redirectStderr=" + String.valueOf(this.redirectStderr) + ", sharedModules=" + String.valueOf(this.sharedModules) + ", subInterpOptions=" + String.valueOf(this.subInterpOptions) + "]";
    }
}

