/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.objects;

import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedron;

public enum SpherePolyhedronDistanceMetric {
    KERNEL_POWER_OF_POINT{

        @Override
        public double distance(SpherePolyhedron spherePolyhedron, double x, double y, double z) {
            return spherePolyhedron.distanceToKernelSquare(x, y, z) - spherePolyhedron.generatrixSphereRadiusSquare();
        }

        @Override
        public double distanceLowerEstimate(double centerX, double centreY, double centerZ, double containingSphereRadius, double x, double y, double z) {
            double dx = centerX - x;
            double dy = centreY - y;
            double dz = centerZ - z;
            double result = Math.sqrt(dx * dx + dy * dy + dz * dz) - containingSphereRadius;
            return result >= 0.0 ? result * result : -containingSphereRadius * containingSphereRadius;
        }

        @Override
        public double distanceToSphere(double centerX, double centreY, double centerZ, double sphereRadius, double x, double y, double z) {
            double dx = centerX - x;
            double dy = centreY - y;
            double dz = centerZ - z;
            return dx * dx + dy * dy + dz * dz - sphereRadius * sphereRadius;
        }

        @Override
        public double radiusIncrementToReduceDistance(double r, double requiredDecreasingOfAllDistances) {
            if (r < 0.0) {
                throw new IllegalArgumentException("Negative radius " + r);
            }
            if (requiredDecreasingOfAllDistances < 0.0) {
                throw new IllegalArgumentException("Negative required decreasing " + requiredDecreasingOfAllDistances);
            }
            return Math.sqrt(r * r + requiredDecreasingOfAllDistances) - r;
        }
    }
    ,
    KERNEL_POWER_OF_POINT_SQRT{

        @Override
        public double distance(SpherePolyhedron spherePolyhedron, double x, double y, double z) {
            double result = spherePolyhedron.distanceToKernelSquare(x, y, z) - spherePolyhedron.generatrixSphereRadiusSquare();
            return result >= 0.0 ? Math.sqrt(result) : -Math.sqrt(-result);
        }

        @Override
        public double distanceLowerEstimate(double centerX, double centreY, double centerZ, double containingSphereRadius, double x, double y, double z) {
            double dx = centerX - x;
            double dy = centreY - y;
            double dz = centerZ - z;
            double result = Math.sqrt(dx * dx + dy * dy + dz * dz) - containingSphereRadius;
            return result >= 0.0 ? result : -containingSphereRadius;
        }

        @Override
        public double distanceToSphere(double centerX, double centreY, double centerZ, double sphereRadius, double x, double y, double z) {
            double dx = centerX - x;
            double dy = centreY - y;
            double dz = centerZ - z;
            double result = dx * dx + dy * dy + dz * dz - sphereRadius * sphereRadius;
            return result >= 0.0 ? Math.sqrt(result) : -Math.sqrt(-result);
        }

        @Override
        public double radiusIncrementToReduceDistance(double r, double requiredDecreasingOfAllDistances) {
            if (r < 0.0) {
                throw new IllegalArgumentException("Negative radius " + r);
            }
            if (requiredDecreasingOfAllDistances < 0.0) {
                throw new IllegalArgumentException("Negative required decreasing " + requiredDecreasingOfAllDistances);
            }
            return Math.sqrt(r * r + requiredDecreasingOfAllDistances * requiredDecreasingOfAllDistances) - r;
        }
    }
    ,
    KERNEL_DISTANCE{

        @Override
        public double distance(SpherePolyhedron spherePolyhedron, double x, double y, double z) {
            return spherePolyhedron.distanceToKernel(x, y, z) - spherePolyhedron.generatrixSphereRadius();
        }

        @Override
        public double distanceLowerEstimate(double centerX, double centreY, double centerZ, double containingSphereRadius, double x, double y, double z) {
            return this.distanceToSphere(centerX, centreY, centerZ, containingSphereRadius, x, y, z);
        }

        @Override
        public double distanceToSphere(double centerX, double centreY, double centerZ, double sphereRadius, double x, double y, double z) {
            double dx = centerX - x;
            double dy = centreY - y;
            double dz = centerZ - z;
            return Math.sqrt(dx * dx + dy * dy + dz * dz) - sphereRadius;
        }

        @Override
        public double radiusIncrementToReduceDistance(double r, double requiredDecreasingOfAllDistances) {
            if (r < 0.0) {
                throw new IllegalArgumentException("Negative radius " + r);
            }
            if (requiredDecreasingOfAllDistances < 0.0) {
                throw new IllegalArgumentException("Negative required decreasing " + requiredDecreasingOfAllDistances);
            }
            return requiredDecreasingOfAllDistances;
        }

        @Override
        public boolean distanceToContainingSphereCanBeGreater() {
            return false;
        }
    };


    public abstract double distance(SpherePolyhedron var1, double var2, double var4, double var6);

    public abstract double distanceLowerEstimate(double var1, double var3, double var5, double var7, double var9, double var11, double var13);

    public abstract double distanceToSphere(double var1, double var3, double var5, double var7, double var9, double var11, double var13);

    public abstract double radiusIncrementToReduceDistance(double var1, double var3);

    public boolean distanceToContainingSphereCanBeGreater() {
        return true;
    }
}

