/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.objects;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.algart.math.Range;
import net.algart.math.RectangularArea;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedraIntersectionsList;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedron;

public final class SpherePolyhedrion {
    public static final int MAX_NUMBER_OF_ELEMENTS = 1024;
    private static final int WEAKENED_MAX_NUMBER_OF_ELEMENTS = 0x100000;
    private static final SpherePolyhedron[] EMPTY_SPHERE_POLYHEDRA = new SpherePolyhedron[0];
    SpherePolyhedron[] elements = EMPTY_SPHERE_POLYHEDRA;
    int n;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private double minZ;
    private double maxZ;
    private RectangularArea containingParallelepiped = null;

    private SpherePolyhedrion(SpherePolyhedron[] elements) {
        Objects.requireNonNull(elements);
        if (elements.length > 1024) {
            throw new IllegalArgumentException("Number of elements of the union " + elements.length + " is too large (>1024)");
        }
        for (SpherePolyhedron spherePolyhedron : elements) {
            Objects.requireNonNull(spherePolyhedron, "One of sphere-polyhedra is null");
        }
        if (elements.length == 0) {
            throw new IllegalArgumentException("Empty array of sphere-polyhedra");
        }
        this.elements = (SpherePolyhedron[])elements.clone();
        this.n = this.elements.length;
        this.rebuild();
    }

    SpherePolyhedrion() {
    }

    public static SpherePolyhedrion unionOf(SpherePolyhedron ... elements) {
        return new SpherePolyhedrion(elements);
    }

    public static SpherePolyhedrion ofSingle(SpherePolyhedron elements) {
        return new SpherePolyhedrion(new SpherePolyhedron[]{elements});
    }

    public int numberOfElements() {
        return this.n;
    }

    public boolean isSphere() {
        return this.n == 1 && this.elements[0].isSphere();
    }

    public SpherePolyhedron element(int index) {
        this.checkElementIndex(index);
        return this.elements[index];
    }

    public List<SpherePolyhedron> elements() {
        return Collections.unmodifiableList(Arrays.asList(this.elements).subList(0, this.n));
    }

    public double centerX() {
        return this.elements[0].centerX();
    }

    public double centerY() {
        return this.elements[0].centerY();
    }

    public double centerZ() {
        return this.elements[0].centerZ();
    }

    public long kindId() {
        return this.elements[0].kindId();
    }

    public double minX() {
        return this.minX;
    }

    public double maxX() {
        return this.maxX;
    }

    public double minY() {
        return this.minY;
    }

    public double maxY() {
        return this.maxY;
    }

    public double minZ() {
        return this.minZ;
    }

    public double maxZ() {
        return this.maxZ;
    }

    public RectangularArea containingParallelepiped() {
        if (this.containingParallelepiped == null) {
            this.containingParallelepiped = RectangularArea.valueOf((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ);
        }
        return this.containingParallelepiped;
    }

    public Range rangeAlongDirection(double dx, double dy, double dz) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int k = 0; k < this.n; ++k) {
            Range range = this.elements[k].rangeAlongDirection(dx, dy, dz);
            min = Math.min(range.min(), min);
            max = Math.max(range.max(), max);
        }
        return Range.valueOf((double)min, (double)max);
    }

    public double summaryVolume() {
        double result = 0.0;
        for (int k = 0; k < this.n; ++k) {
            result += this.elements[k].volume();
        }
        return result;
    }

    public double maxContainingSphereRadius() {
        double result = 0.0;
        for (int k = 0; k < this.n; ++k) {
            result = Math.max(result, this.elements[k].containingSphereRadius());
        }
        return result;
    }

    public SpherePolyhedrion symmetry() {
        if (this.n == 1 && this.centerX() == 0.0 && this.centerY() == 0.0 && this.centerZ() == 0.0) {
            return this;
        }
        SpherePolyhedrion result = new SpherePolyhedrion();
        result.setTo(this);
        result.setToSymmetry();
        return result;
    }

    public boolean containsPoint(double x, double y, double z, boolean essentially, double characteristicSize) {
        for (int k = 0; k < this.n; ++k) {
            if (!this.elements[k].containsPoint(x, y, z, essentially, characteristicSize)) continue;
            return true;
        }
        return false;
    }

    public SpherePolyhedrion moveTo(double newCenterX, double newCenterY, double newCenterZ) {
        SpherePolyhedrion result = new SpherePolyhedrion(this.elements);
        double shiftX = newCenterX - this.elements[0].centerX();
        double shiftY = newCenterY - this.elements[0].centerY();
        double shiftZ = newCenterZ - this.elements[0].centerZ();
        result.elements[0] = result.elements[0].moveTo(newCenterX, newCenterY, newCenterZ);
        for (int k = 1; k < this.n; ++k) {
            result.elements[k] = result.elements[k].moveTo(this.elements[k].centerX() + shiftX, this.elements[k].centerY() + shiftY, this.elements[k].centerZ() + shiftZ);
        }
        result.minX += shiftX;
        result.maxX += shiftX;
        result.minY += shiftY;
        result.maxY += shiftY;
        result.minZ += shiftZ;
        result.maxZ += shiftZ;
        result.containingParallelepiped = null;
        return result;
    }

    public String toString() {
        return "union of " + this.numberOfElements() + " sphere-polyhedra: " + Arrays.toString(this.elements);
    }

    void setCenter(double centerX, double centerY, double centerZ) {
        double shiftX = centerX - this.elements[0].centerX();
        double shiftY = centerY - this.elements[0].centerY();
        double shiftZ = centerZ - this.elements[0].centerZ();
        this.elements[0].setCenter(centerX, centerY, centerZ);
        for (int k = 1; k < this.n; ++k) {
            this.elements[k].setCenter(this.elements[k].centerX() + shiftX, this.elements[k].centerY() + shiftY, this.elements[k].centerZ() + shiftZ);
        }
        this.minX += shiftX;
        this.maxX += shiftX;
        this.minY += shiftY;
        this.maxY += shiftY;
        this.minZ += shiftZ;
        this.maxZ += shiftZ;
        this.containingParallelepiped = null;
    }

    void setZeroCenter() {
        this.setCenter(0.0, 0.0, 0.0);
    }

    void setNumberOfElements(int numberOfElements) {
        if (numberOfElements <= 0) {
            throw new IllegalArgumentException("Zero or negative number of elements: " + numberOfElements);
        }
        this.ensureCapacity(numberOfElements);
        for (int k = 0; k < numberOfElements; ++k) {
            if (this.elements[k] != null) continue;
            this.elements[k] = new SpherePolyhedron();
        }
        this.n = numberOfElements;
    }

    void setTo(SpherePolyhedrion other) {
        Objects.requireNonNull(other, "Null other");
        this.setNumberOfElements(other.n);
        for (int k = 0; k < this.n; ++k) {
            this.elements[k].setTo(other.elements[k]);
        }
        this.minX = other.minX;
        this.maxX = other.maxX;
        this.minY = other.minY;
        this.maxY = other.maxY;
        this.minZ = other.minZ;
        this.maxZ = other.maxZ;
        this.containingParallelepiped = other.containingParallelepiped;
    }

    void setToSymmetry() {
        for (int k = 0; k < this.n; ++k) {
            this.elements[k].setToSymmetry();
        }
        double t = this.minX;
        this.minX = -this.maxX;
        this.maxX = -t;
        t = this.minY;
        this.minY = -this.maxY;
        this.maxY = -t;
        t = this.minZ;
        this.minZ = -this.maxZ;
        this.maxZ = -t;
        this.containingParallelepiped = null;
    }

    void minkowskiAdd(SpherePolyhedron added) {
        for (int k = 0; k < this.n; ++k) {
            this.elements[k].minkowskiAdd(added);
        }
        this.minX += added.minX();
        this.maxX += added.maxX();
        this.minY += added.minY();
        this.maxY += added.maxY();
        this.minZ += added.minZ();
        this.maxZ += added.maxZ();
        this.containingParallelepiped = null;
    }

    void minkowskiAddSymmetric() {
        int n = this.n;
        if ((long)n * (long)n > 0x100000L) {
            throw new AssertionError((Object)"Number of elements of the result union is too large (>1048576)");
        }
        this.setNumberOfElements(n * n);
        int resultIndex = n;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (i >= j) continue;
                assert (resultIndex <= this.n);
                SpherePolyhedron sumEiEj = this.elements[resultIndex];
                SpherePolyhedron sumEjEi = this.elements[resultIndex + 1];
                assert (sumEiEj != null && sumEjEi != null) : "All elements after setNumberOfElements must be non-null";
                sumEiEj.setTo(this.elements[j]);
                sumEiEj.setToSymmetry();
                sumEiEj.minkowskiAdd(this.elements[i]);
                sumEjEi.setTo(sumEiEj);
                sumEjEi.setToSymmetry();
                resultIndex += 2;
            }
        }
        assert (resultIndex == this.n);
        for (int k = 0; k < n; ++k) {
            this.elements[k].minkowskiAddSymmetric();
        }
        this.rebuild();
    }

    void rebuild() {
        this.minX = this.elements[0].minX();
        this.maxX = this.elements[0].maxX();
        this.minY = this.elements[0].minY();
        this.maxY = this.elements[0].maxY();
        this.minZ = this.elements[0].minZ();
        this.maxZ = this.elements[0].maxZ();
        for (int k = 1; k < this.n; ++k) {
            double elementMaxZ;
            double elementMinZ;
            double elementMaxY;
            double elementMinY;
            double elementMaxX;
            double elementMinX = this.elements[k].minX();
            if (elementMinX < this.minX) {
                this.minX = elementMinX;
            }
            if ((elementMaxX = this.elements[k].maxX()) > this.maxX) {
                this.maxX = elementMaxX;
            }
            if ((elementMinY = this.elements[k].minY()) < this.minY) {
                this.minY = elementMinY;
            }
            if ((elementMaxY = this.elements[k].maxY()) > this.maxY) {
                this.maxY = elementMaxY;
            }
            if ((elementMinZ = this.elements[k].minZ()) < this.minZ) {
                this.minZ = elementMinZ;
            }
            if (!((elementMaxZ = this.elements[k].maxZ()) > this.maxZ)) continue;
            this.maxZ = elementMaxZ;
        }
        this.containingParallelepiped = null;
    }

    private void ensureCapacity(int newUnsignedNumberOfElements) {
        if (SpherePolyhedraIntersectionsList.unsigned(newUnsignedNumberOfElements) > (long)this.elements.length) {
            long newLength = SpherePolyhedraIntersectionsList.unsigned(newUnsignedNumberOfElements);
            if (newLength > Integer.MAX_VALUE) {
                throw new AssertionError((Object)"Should be never called for lengths, greater than number of elements of already existing sphere-polyhedrions");
            }
            this.elements = Arrays.copyOf(this.elements, (int)newLength);
        }
    }

    private void checkElementIndex(int k) {
        if (k < 0 || k >= this.n) {
            throw new IndexOutOfBoundsException("Index of sphere-polyhedron " + k + " in the union is out of range 0.." + (this.n - 1));
        }
    }
}

