/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.objects;

import java.util.Objects;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.Matrix;
import net.algart.arrays.PFixedArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.arrays.UpdatablePFixedArray;
import net.algart.math.geometry.Orthonormal3DBasis;
import net.algart.math.geometry.StraightLine3D;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedra;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedraOverlappingVoxelBuilder;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedraSimpleVoxelBuilder;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedraStraightIntersectionsFinder;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedronDistanceMetric;

public abstract class SpherePolyhedraVoxelBuilder {
    private static final boolean MULTITHREADING_OPTIMIZATION = true;
    private static final int MULTITHREADING_YZ_BLOCK_LENGTH = 512;
    final SpherePolyhedra spherePolyhedra;
    final int dimX;
    final int dimY;
    final int dimZ;
    final int dimYZ;
    final Matrix<? extends UpdatablePFixedArray> voxels;
    final Matrix<? extends UpdatablePArray> voxelDistances;
    final BuildingDistancesMode distancesMode;
    final UpdatablePFixedArray voxelArray;
    final UpdatablePArray voxelDistancesArray;
    private int voxelOriginX = 0;
    private int voxelOriginY = 0;
    private int voxelOriginZ = 0;
    private double spherePolyhedraOriginX = 0.0;
    private double spherePolyhedraOriginY = 0.0;
    private double spherePolyhedraOriginZ = 0.0;
    private Orthonormal3DBasis rotationBasis = Orthonormal3DBasis.DEFAULT;
    private Orthonormal3DBasis inverseBasis = this.rotationBasis.inverse();
    double scaleX = 1.0;
    double scaleY = 1.0;
    double scaleZ = 1.0;
    private VoxelValueSelector voxelValueSelector = VoxelValueSelector.CONSTANT_1;
    final int numberOfThreads;
    final SpherePolyhedraStraightIntersectionsFinder[] threadIntersectionsFinders;
    int[] spherePolyhedraVoxelValues = null;

    SpherePolyhedraVoxelBuilder(SpherePolyhedra spherePolyhedra, Class<?> elementType, int dimX, int dimY, int dimZ, BuildingDistancesMode distancesMode) {
        this.spherePolyhedra = Objects.requireNonNull(spherePolyhedra, "Null sphere-polyhedra array");
        Objects.requireNonNull(elementType, "Null elementType");
        if (!PFixedArray.class.isAssignableFrom(Arrays.type(Array.class, elementType))) {
            throw new IllegalArgumentException("Illegal element type " + String.valueOf(elementType) + ": it should be one of fixed-point primitive numeric, character or boolean types");
        }
        Objects.requireNonNull(distancesMode, "Null distancesMode");
        if (dimX <= 0) {
            throw new IllegalArgumentException("Zero or negative dimX = " + dimX);
        }
        if (dimY <= 0) {
            throw new IllegalArgumentException("Zero or negative dimY = " + dimY);
        }
        if (dimZ <= 0) {
            throw new IllegalArgumentException("Zero or negative dimZ = " + dimZ);
        }
        this.dimX = dimX;
        this.dimY = dimY;
        this.dimZ = dimZ;
        this.distancesMode = distancesMode;
        this.voxels = Arrays.SMM.newMatrix(UpdatablePFixedArray.class, elementType, new long[]{dimX, dimY, dimZ});
        this.voxelArray = (UpdatablePFixedArray)this.voxels.array();
        if (distancesMode != BuildingDistancesMode.NONE) {
            this.voxelDistances = Arrays.SMM.newMatrix(UpdatablePArray.class, Float.TYPE, new long[]{dimX, dimY, dimZ});
            this.voxelDistancesArray = (UpdatablePArray)this.voxelDistances.array();
        } else {
            this.voxelDistances = null;
            this.voxelDistancesArray = null;
        }
        this.numberOfThreads = Arrays.SystemSettings.cpuCount();
        this.threadIntersectionsFinders = new SpherePolyhedraStraightIntersectionsFinder[this.numberOfThreads];
        for (int t = 0; t < this.numberOfThreads; ++t) {
            this.threadIntersectionsFinders[t] = new SpherePolyhedraStraightIntersectionsFinder(spherePolyhedra);
        }
        this.dimYZ = dimY * dimZ;
    }

    public static SpherePolyhedraSimpleVoxelBuilder newSimpleBuilder(SpherePolyhedra spherePolyhedra, Class<?> elementType, int dimX, int dimY, int dimZ) {
        return new SpherePolyhedraSimpleVoxelBuilder(spherePolyhedra, elementType, dimX, dimY, dimZ);
    }

    public static SpherePolyhedraOverlappingVoxelBuilder newDistanceMapBuilder(SpherePolyhedra spherePolyhedra, Class<?> elementType, int dimX, int dimY, int dimZ, BuildingDistancesMode distancesMode, SpherePolyhedronDistanceMetric distanceMetric) {
        return new SpherePolyhedraOverlappingVoxelBuilder(spherePolyhedra, elementType, dimX, dimY, dimZ, distancesMode, distanceMetric);
    }

    public int dimX() {
        return this.dimX;
    }

    public int dimY() {
        return this.dimY;
    }

    public int dimZ() {
        return this.dimZ;
    }

    public Matrix<? extends UpdatablePArray> voxels() {
        return this.voxels;
    }

    public Matrix<? extends UpdatablePArray> voxelDistances() {
        return this.voxelDistances;
    }

    public int getVoxelOriginX() {
        return this.voxelOriginX;
    }

    public SpherePolyhedraVoxelBuilder setVoxelOriginX(int voxelOriginX) {
        this.voxelOriginX = voxelOriginX;
        return this;
    }

    public int getVoxelOriginY() {
        return this.voxelOriginY;
    }

    public SpherePolyhedraVoxelBuilder setVoxelOriginY(int voxelOriginY) {
        this.voxelOriginY = voxelOriginY;
        return this;
    }

    public int getVoxelOriginZ() {
        return this.voxelOriginZ;
    }

    public SpherePolyhedraVoxelBuilder setVoxelOriginZ(int voxelOriginZ) {
        this.voxelOriginZ = voxelOriginZ;
        return this;
    }

    public SpherePolyhedraVoxelBuilder setVoxelOrigin(int originX, int originY, int originZ) {
        this.voxelOriginX = originX;
        this.voxelOriginY = originY;
        this.voxelOriginZ = originZ;
        return this;
    }

    public double getSpherePolyhedraOriginX() {
        return this.spherePolyhedraOriginX;
    }

    public SpherePolyhedraVoxelBuilder setSpherePolyhedraOriginX(double spherePolyhedraOriginX) {
        this.spherePolyhedraOriginX = spherePolyhedraOriginX;
        return this;
    }

    public double getSpherePolyhedraOriginY() {
        return this.spherePolyhedraOriginY;
    }

    public SpherePolyhedraVoxelBuilder setSpherePolyhedraOriginY(double spherePolyhedraOriginY) {
        this.spherePolyhedraOriginY = spherePolyhedraOriginY;
        return this;
    }

    public double getSpherePolyhedraOriginZ() {
        return this.spherePolyhedraOriginZ;
    }

    public SpherePolyhedraVoxelBuilder setSpherePolyhedraOriginZ(double spherePolyhedraOriginZ) {
        this.spherePolyhedraOriginZ = spherePolyhedraOriginZ;
        return this;
    }

    public SpherePolyhedraVoxelBuilder setSpherePolyhedraOrigin(double spherePolyhedraOriginX, double spherePolyhedraOriginY, double spherePolyhedraOriginZ) {
        this.spherePolyhedraOriginX = spherePolyhedraOriginX;
        this.spherePolyhedraOriginY = spherePolyhedraOriginY;
        this.spherePolyhedraOriginZ = spherePolyhedraOriginZ;
        return this;
    }

    public Orthonormal3DBasis getRotationBasis() {
        return this.rotationBasis;
    }

    public SpherePolyhedraVoxelBuilder setRotationBasis(Orthonormal3DBasis rotationBasis) {
        this.rotationBasis = Objects.requireNonNull(rotationBasis, "Null rotationBasis");
        this.inverseBasis = rotationBasis.inverse();
        return this;
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public SpherePolyhedraVoxelBuilder setScaleX(double scaleX) {
        if (scaleX <= 0.0) {
            throw new IllegalArgumentException("Zero or negative scaleX");
        }
        this.scaleX = scaleX;
        return this;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public SpherePolyhedraVoxelBuilder setScaleY(double scaleY) {
        if (scaleY <= 0.0) {
            throw new IllegalArgumentException("Zero or negative scaleY");
        }
        this.scaleY = scaleY;
        return this;
    }

    public double getScaleZ() {
        return this.scaleZ;
    }

    public SpherePolyhedraVoxelBuilder setScaleZ(double scaleZ) {
        if (scaleZ <= 0.0) {
            throw new IllegalArgumentException("Zero or negative scaleZ");
        }
        this.scaleZ = scaleZ;
        return this;
    }

    public SpherePolyhedraVoxelBuilder setScales(double scaleX, double scaleY, double scaleZ) {
        return this.setScaleX(scaleX).setScaleY(scaleY).setScaleZ(scaleZ);
    }

    public SpherePolyhedraVoxelBuilder setScale(double scale) {
        if (scale <= 0.0) {
            throw new IllegalArgumentException("Zero or negative scale");
        }
        this.scaleX = scale;
        this.scaleY = scale;
        this.scaleZ = scale;
        return this;
    }

    public VoxelValueSelector getVoxelValueSelector() {
        return this.voxelValueSelector;
    }

    public SpherePolyhedraVoxelBuilder setVoxelValueSelector(VoxelValueSelector voxelValueSelector) {
        this.voxelValueSelector = Objects.requireNonNull(voxelValueSelector, "Null voxelValueSelector");
        return this;
    }

    public void build() {
        this.spherePolyhedraVoxelValues = new int[this.spherePolyhedra.numberOfSpherePolyhedra()];
        for (int index = 0; index < this.spherePolyhedraVoxelValues.length; ++index) {
            int objectIndex = this.spherePolyhedra.containingObjectIndex(index);
            this.spherePolyhedraVoxelValues[index] = this.voxelValueSelector.value(this.spherePolyhedra, objectIndex, index);
        }
        this.preprocess();
        new Arrays.ParallelExecutor(null, null, (Array)Arrays.nIntCopies((long)this.dimYZ, (int)0), 512, this.numberOfThreads, this.dimYZ == 0 ? 0L : (long)((this.dimYZ - 1) / 512 + 1)){

            protected void processSubArr(long position, int count, int threadIndex) {
                int from = (int)position;
                int to = from + count;
                for (int straightIndex = from; straightIndex < to; ++straightIndex) {
                    SpherePolyhedraVoxelBuilder.this.processStraight(straightIndex, threadIndex);
                }
            }
        }.process();
    }

    abstract void preprocess();

    abstract void processStraight(int var1, int var2);

    void fill(long startPosition, int x1, int x2, long filler) {
        int to;
        int from;
        if (x2 >= 0 && x1 < this.dimX && (from = Math.max(x1, 0)) < (to = Math.min(x2 + 1, this.dimX))) {
            this.voxelArray.fill(startPosition + (long)from, (long)(to - from), filler);
        }
    }

    StraightLine3D getSraightAlongVoxelX(int voxelX, int voxelY, int voxelZ) {
        double correctedX = this.shiftAndScaleVoxelX(voxelX);
        double correctedY = this.shiftAndScaleVoxelY(voxelY);
        double correctedZ = this.shiftAndScaleVoxelZ(voxelZ);
        double x0 = this.spherePolyhedraOriginX + this.inverseBasis.x(correctedX, correctedY, correctedZ);
        double y0 = this.spherePolyhedraOriginY + this.inverseBasis.y(correctedX, correctedY, correctedZ);
        double z0 = this.spherePolyhedraOriginZ + this.inverseBasis.z(correctedX, correctedY, correctedZ);
        return StraightLine3D.newLineAlongI((double)x0, (double)y0, (double)z0, (Orthonormal3DBasis)this.inverseBasis);
    }

    private double shiftAndScaleVoxelX(int x) {
        return (double)(x - this.voxelOriginX) / this.scaleX;
    }

    private double shiftAndScaleVoxelY(int y) {
        return (double)(y - this.voxelOriginY) / this.scaleY;
    }

    private double shiftAndScaleVoxelZ(int z) {
        return (double)(z - this.voxelOriginZ) / this.scaleZ;
    }

    public static interface VoxelValueSelector {
        public static final VoxelValueSelector INCREMENTED_OBJECT_INDEX_SELECTOR = (spherePolyhedra, objectIndex, spherePolyhedronIndex) -> objectIndex + 1;
        public static final VoxelValueSelector CONSTANT_1 = (spherePolyhedra, objectIndex, spherePolyhedronIndex) -> 1;
        public static final int SKIP = -1;

        public int value(SpherePolyhedra var1, int var2, int var3);
    }

    public static enum BuildingDistancesMode {
        NONE(false),
        ONLY_INSIDE_OBJECTS(false),
        ALL_MATRIX_UNTIL_MAX_DISTANCE(true),
        ALL_MATRIX(true);

        private final boolean analyzeOutsideObjects;

        private BuildingDistancesMode(boolean analyzeOutsideObjects) {
            this.analyzeOutsideObjects = analyzeOutsideObjects;
        }

        public boolean analyzeOutsideObjects() {
            return this.analyzeOutsideObjects;
        }
    }
}

