/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.objects;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntUnaryOperator;
import net.algart.arrays.ArrayExchanger;
import net.algart.arrays.ArraySorter;
import net.algart.arrays.JArrays;
import net.algart.arrays.TooLargeArrayException;
import net.algart.math.geometry.StraightLine3D;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedra;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedraIntersection;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedraIntersectionsList;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrion;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedron;

public final class SpherePolyhedraStraightIntersectionsFinder {
    private SpherePolyhedra spherePolyhedra;
    private int numberOfPoints = 0;
    double[] t = JArrays.EMPTY_DOUBLES;
    boolean[] entryFlags = JArrays.EMPTY_BOOLEANS;
    int[] spherePolyhedronIndexes = JArrays.EMPTY_INTS;
    private SpherePolyhedrion addedObject = SpherePolyhedrion.ofSingle(new SpherePolyhedron());
    private ObjectsDilator dilator = null;
    private double minimalAlmostZeroPositiveT = 0.0;
    private final SpherePolyhedraIntersectionsList workPoints = new SpherePolyhedraIntersectionsList();
    private final SpherePolyhedron workSpherePolyhedron = new SpherePolyhedron();
    private final ArrayExchanger exchanger = (firstIndex, secondIndex) -> {
        int i1 = (int)firstIndex;
        int i2 = (int)secondIndex;
        double temp = this.t[i1];
        this.t[i1] = this.t[i2];
        this.t[i2] = temp;
        int temp2 = this.entryFlags[i1];
        this.entryFlags[i1] = this.entryFlags[i2];
        this.entryFlags[i2] = temp2;
        temp2 = this.spherePolyhedronIndexes[i1];
        this.spherePolyhedronIndexes[i1] = this.spherePolyhedronIndexes[i2];
        this.spherePolyhedronIndexes[i2] = temp2;
    };

    public SpherePolyhedraStraightIntersectionsFinder(SpherePolyhedra spherePolyhedra) {
        this.spherePolyhedra = Objects.requireNonNull(spherePolyhedra, "Null sphere-polyhedra array");
    }

    public SpherePolyhedraStraightIntersectionsFinder setSpherePolyhedra(SpherePolyhedra spherePolyhedra) {
        this.spherePolyhedra = Objects.requireNonNull(spherePolyhedra, "Null sphere-polyhedra array");
        return this;
    }

    public SpherePolyhedraStraightIntersectionsFinder setAddedForDilation(SpherePolyhedrion addedObject) {
        this.addedObject = Objects.requireNonNull(addedObject, "Null addedObject");
        return this;
    }

    public SpherePolyhedraStraightIntersectionsFinder setDilator(ObjectsDilator dilator) {
        this.dilator = dilator;
        return this;
    }

    public SpherePolyhedraStraightIntersectionsFinder setMinimalAlmostZeroPositiveT(double minimalAlmostZeroPositiveT) {
        this.minimalAlmostZeroPositiveT = minimalAlmostZeroPositiveT;
        return this;
    }

    public void findAllIntersections(StraightLine3D straight) {
        this.findAllIntersections(straight, ObjectsFilter.ALWAYS);
    }

    public void findAllIntersections(StraightLine3D straight, ObjectsFilter useThisSpherePolyherdon) {
        SpherePolyhedron addedSpherePolyhedronByDilator;
        Objects.requireNonNull(straight, "Null straight");
        Objects.requireNonNull(useThisSpherePolyherdon, "Null useThisSpherePolyherdon");
        this.numberOfPoints = 0;
        if (this.dilator != null) {
            this.addedObject.setNumberOfElements(1);
            this.addedObject.setZeroCenter();
            addedSpherePolyhedronByDilator = this.addedObject.element(0);
        } else {
            addedSpherePolyhedronByDilator = null;
        }
        double lastDilationSphereRadius = -1.0;
        int n = this.spherePolyhedra.numberOfSpherePolyhedra;
        for (int k = 0; k < n; ++k) {
            double generatrixSphereRadius;
            double dilationSphereRadius;
            if (!useThisSpherePolyherdon.accept(k)) continue;
            if (addedSpherePolyhedronByDilator != null && (dilationSphereRadius = this.dilator.necessaryRadiusIncrement(generatrixSphereRadius = this.spherePolyhedra.xyzr[4 * k + 3])) != lastDilationSphereRadius) {
                addedSpherePolyhedronByDilator.generatrixSet.setToSphere(dilationSphereRadius);
                addedSpherePolyhedronByDilator.rebuild();
                lastDilationSphereRadius = dilationSphereRadius;
            }
            for (SpherePolyhedron addedElement : this.addedObject.elements) {
                if (!this.findIntersectionsWithSingleSpherePolyhedron(this.workPoints, straight, k, addedElement)) continue;
                this.ensureCapacity((long)this.numberOfPoints + 2L);
                SpherePolyhedraIntersection entry = this.workPoints.get(0);
                SpherePolyhedraIntersection exit = this.workPoints.get(1);
                this.t[this.numberOfPoints] = entry.t();
                this.entryFlags[this.numberOfPoints] = true;
                this.spherePolyhedronIndexes[this.numberOfPoints] = k;
                ++this.numberOfPoints;
                this.t[this.numberOfPoints] = exit.t();
                this.entryFlags[this.numberOfPoints] = false;
                this.spherePolyhedronIndexes[this.numberOfPoints] = k;
                assert (entry.t() <= exit.t());
                ++this.numberOfPoints;
            }
        }
    }

    public int findLastIntersection(SpherePolyhedraIntersection resultPosition, StraightLine3D straight) {
        Objects.requireNonNull(resultPosition, "Null resultPosition");
        Objects.requireNonNull(straight, "Null straight");
        resultPosition.setNegativeInvinify();
        assert (this.addedObject != null);
        int index = -1;
        int n = this.spherePolyhedra.numberOfSpherePolyhedra;
        for (int k = 0; k < n; ++k) {
            for (SpherePolyhedron addedElement : this.addedObject.elements) {
                if (!this.findIntersectionsWithSingleSpherePolyhedron(this.workPoints, straight, k, addedElement)) continue;
                SpherePolyhedraIntersection exit = this.workPoints.get(1);
                assert (exit.exists());
                if (!(exit.t() >= resultPosition.t())) continue;
                resultPosition.setTo(exit);
                index = k;
            }
        }
        return index;
    }

    public int findFirstPositiveIntersection(SpherePolyhedraIntersection resultPosition, StraightLine3D straight, int nonCheckedIndex) {
        Objects.requireNonNull(resultPosition, "Null resultPosition point");
        Objects.requireNonNull(straight, "Null straight");
        assert (this.addedObject != null);
        resultPosition.setPositiveInvinify();
        int index = -1;
        int n = this.spherePolyhedra.numberOfSpherePolyhedra;
        for (int k = 0; k < n; ++k) {
            if (k == nonCheckedIndex) continue;
            for (SpherePolyhedron addedElement : this.addedObject.elements) {
                if (!this.findIntersectionsWithSingleSpherePolyhedron(this.workPoints, straight, k, addedElement)) continue;
                SpherePolyhedraIntersection entry = this.workPoints.get(0);
                assert (entry.exists());
                if (!(entry.t() > this.minimalAlmostZeroPositiveT) || !(entry.t() <= resultPosition.t())) continue;
                resultPosition.setTo(entry);
                index = k;
            }
        }
        return index;
    }

    public boolean findFirstIntersectionWithSingleSpherePolyhedron(SpherePolyhedraIntersection resultPosition, StraightLine3D straight, int selectedSpherePolyhedronIndex) {
        Objects.requireNonNull(resultPosition, "Null resultPosition point");
        Objects.requireNonNull(straight, "Null straight");
        if (selectedSpherePolyhedronIndex < 0) {
            throw new IllegalArgumentException("Negative sphere-polyhedron index");
        }
        assert (this.addedObject != null);
        resultPosition.setPositiveInvinify();
        boolean found = false;
        for (SpherePolyhedron addedElement : this.addedObject.elements) {
            if (!this.findIntersectionsWithSingleSpherePolyhedron(this.workPoints, straight, selectedSpherePolyhedronIndex, addedElement)) continue;
            SpherePolyhedraIntersection entry = this.workPoints.get(0);
            assert (entry.exists());
            if (!(entry.t() <= resultPosition.t())) continue;
            resultPosition.setTo(entry);
            found = true;
        }
        return found;
    }

    public boolean findIntersectionsWithSingleSpherePolyhedron(SpherePolyhedraIntersectionsList results, StraightLine3D straight, int spherePolyhedronIndex, SpherePolyhedron addedSpherePolyhedron) {
        Objects.requireNonNull(results, "Null result list of points");
        Objects.requireNonNull(straight, "Null straight");
        results.clear();
        results.allocateAfterEnd(2);
        results.increaseSize(2);
        SpherePolyhedraIntersection entry = results.get(0);
        SpherePolyhedraIntersection exit = results.get(1);
        double rSum = this.spherePolyhedra.containingSphereRadius(spherePolyhedronIndex);
        if (addedSpherePolyhedron == null) {
            if (!SpherePolyhedron.intersectionOfSphereWithStraight(this.spherePolyhedra.xyzr[4 * spherePolyhedronIndex], this.spherePolyhedra.xyzr[4 * spherePolyhedronIndex + 1], this.spherePolyhedra.xyzr[4 * spherePolyhedronIndex + 2], rSum, 1.0 / rSum, straight, entry, exit)) {
                return false;
            }
            if (this.spherePolyhedra.isSphere(spherePolyhedronIndex)) {
                return true;
            }
            this.spherePolyhedra.getSpherePolyhedron(this.workSpherePolyhedron, spherePolyhedronIndex);
        } else {
            if (!SpherePolyhedron.intersectionOfSphereWithStraight(this.spherePolyhedra.xyzr[4 * spherePolyhedronIndex] + addedSpherePolyhedron.centerX(), this.spherePolyhedra.xyzr[4 * spherePolyhedronIndex + 1] + addedSpherePolyhedron.centerY(), this.spherePolyhedra.xyzr[4 * spherePolyhedronIndex + 2] + addedSpherePolyhedron.centerZ(), rSum += addedSpherePolyhedron.containingSphereRadius(), 1.0 / rSum, straight, entry, exit)) {
                return false;
            }
            if (this.spherePolyhedra.isSphere(spherePolyhedronIndex) && addedSpherePolyhedron.isSphere()) {
                return true;
            }
            this.spherePolyhedra.getMinkowskiSum(this.workSpherePolyhedron, spherePolyhedronIndex, addedSpherePolyhedron);
        }
        return this.workSpherePolyhedron.intersectionWithStraight(results, straight);
    }

    public void sortByLabel(IntUnaryOperator labelValueSelector) {
        Objects.requireNonNull(labelValueSelector, "Null labelValueSelector");
        ArraySorter.getQuickSorter().sort(0L, (long)this.numberOfPoints, (firstIndex, secondIndex) -> {
            int label2;
            int i1 = (int)firstIndex;
            int spherePolyhedronIndex1 = this.spherePolyhedronIndexes[i1];
            int i2 = (int)secondIndex;
            int spherePolyhedronIndex2 = this.spherePolyhedronIndexes[i2];
            if (spherePolyhedronIndex1 == spherePolyhedronIndex2) {
                return this.entryFlags[i1] && !this.entryFlags[i2];
            }
            int label1 = labelValueSelector.applyAsInt(spherePolyhedronIndex1);
            return label1 == (label2 = labelValueSelector.applyAsInt(spherePolyhedronIndex2)) ? spherePolyhedronIndex1 < spherePolyhedronIndex2 : label1 < label2;
        }, this.exchanger);
    }

    public void sortByTAndEntryFlag() {
        ArraySorter.getQuickSorter().sort(0L, (long)this.numberOfPoints, (firstIndex, secondIndex) -> {
            int i1 = (int)firstIndex;
            int i2 = (int)secondIndex;
            if (this.spherePolyhedronIndexes[i1] == this.spherePolyhedronIndexes[i2]) {
                return this.entryFlags[i1] && !this.entryFlags[i2];
            }
            return this.t[i1] < this.t[i2];
        }, this.exchanger);
    }

    public void sortByT() {
        ArraySorter.getQuickSorter().sort(0L, (long)this.numberOfPoints, (firstIndex, secondIndex) -> {
            int i1 = (int)firstIndex;
            int i2 = (int)secondIndex;
            return this.t[i1] < this.t[i2];
        }, this.exchanger);
    }

    public int numberOfPoints() {
        return this.numberOfPoints;
    }

    public double t(int index) {
        if (index < 0 || index >= this.numberOfPoints) {
            throw new IndexOutOfBoundsException("Index of point " + index + " is out of range 0.." + (this.numberOfPoints - 1));
        }
        return this.t[index];
    }

    public double[] t() {
        return Arrays.copyOfRange(this.t, 0, this.numberOfPoints);
    }

    public boolean[] entryFlags() {
        return Arrays.copyOfRange(this.entryFlags, 0, this.numberOfPoints);
    }

    public int[] spherePolyhedronIndexes() {
        return Arrays.copyOfRange(this.spherePolyhedronIndexes, 0, this.numberOfPoints);
    }

    private void ensureCapacity(long newNumberOfPoints) {
        if (newNumberOfPoints > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large array required");
        }
        assert (newNumberOfPoints == (long)((int)newNumberOfPoints));
        if (newNumberOfPoints > (long)this.t.length) {
            int newLength = Math.max(16, Math.max((int)newNumberOfPoints, (int)Math.min(Integer.MAX_VALUE, (long)(2.0 * (double)this.t.length))));
            this.t = Arrays.copyOf(this.t, newLength);
            this.entryFlags = Arrays.copyOf(this.entryFlags, newLength);
            this.spherePolyhedronIndexes = Arrays.copyOf(this.spherePolyhedronIndexes, newLength);
        }
    }

    @FunctionalInterface
    public static interface ObjectsDilator {
        public double necessaryRadiusIncrement(double var1);
    }

    @FunctionalInterface
    public static interface ObjectsFilter {
        public static final ObjectsFilter ALWAYS = objectIndex -> true;

        public boolean accept(int var1);
    }
}

