/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.objects;

import net.algart.math.geometry.Orthonormal3DBasis;
import net.algart.math.geometry.StraightLine3D;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedraIntersection;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedraIntersectionsList;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedron;

class SpherePolyhedraIntersectionsTools {
    private SpherePolyhedraIntersectionsTools() {
    }

    static int intersectionsOf3SpherePolyhedra(SpherePolyhedraIntersectionsList result, SpherePolyhedron spherePolyhedronA, SpherePolyhedron spherePolyhedronB, SpherePolyhedron spherePolyhedronC) {
        result.clear();
        SpherePolyhedraIntersectionsTools.addIntersectionsOf3SpherePolyhedra(result, spherePolyhedronA, spherePolyhedronB, spherePolyhedronC);
        return result.size();
    }

    static void addIntersectionsOf3SpherePolyhedra(SpherePolyhedraIntersectionsList result, SpherePolyhedron spherePolyhedronA, SpherePolyhedron spherePolyhedronB, SpherePolyhedron spherePolyhedronC) {
        throw new UnsupportedOperationException();
    }

    static boolean intersectionOfSphereWithStraight(int vertexIndex, double x, double y, double z, double r, double rInv, StraightLine3D straight, SpherePolyhedraIntersection centerAtStraight, SpherePolyhedraIntersection result1, SpherePolyhedraIntersection result2) {
        double m;
        double q;
        double discriminant;
        double p = straight.vectorProjection(x -= centerAtStraight.x(), y -= centerAtStraight.y(), z -= centerAtStraight.z());
        if ((discriminant = p * p - (q = ((m = Orthonormal3DBasis.length((double)x, (double)y, (double)z)) + r) * (m - r))) < 0.0) {
            result1.remove();
            result2.remove();
            return false;
        }
        double sqrt = Math.sqrt(discriminant);
        result1.setAll(SpherePolyhedraIntersection.SurfaceType.STRAIGHT_SPHERE, p - sqrt, -sqrt * rInv, vertexIndex);
        result2.setAll(SpherePolyhedraIntersection.SurfaceType.STRAIGHT_SPHERE, p + sqrt, sqrt * rInv, vertexIndex);
        return true;
    }

    static boolean intersectionsOf3Spheres(SpherePolyhedron spherePolyhedronA, SpherePolyhedron spherePolyhedronB, SpherePolyhedron spherePolyhedronC, int vertexA, int vertexB, int vertexC, SpherePolyhedraIntersection result1, SpherePolyhedraIntersection result2) {
        double x = spherePolyhedronA.vertexX(vertexA);
        double y = spherePolyhedronA.vertexY(vertexA);
        double z = spherePolyhedronA.vertexZ(vertexA);
        if (spherePolyhedronA.generatrixRadius == 0.0 || spherePolyhedronB.generatrixRadius == 0.0 || spherePolyhedronC.generatrixRadius == 0.0) {
            return false;
        }
        double ix = spherePolyhedronB.vertexX(vertexB) - x;
        double iy = spherePolyhedronB.vertexY(vertexB) - y;
        double iz = spherePolyhedronB.vertexZ(vertexB) - z;
        double iSqr = ix * ix + iy * iy + iz * iz;
        double jx = spherePolyhedronC.vertexX(vertexC) - x;
        double jy = spherePolyhedronC.vertexY(vertexC) - y;
        double jz = spherePolyhedronC.vertexZ(vertexC) - z;
        double jSqr = jx * jx + jy * jy + jz * jz;
        if (iSqr < 1.0E-40 || jSqr < 1.0E-40) {
            return false;
        }
        double ij = ix * jx + iy * jy + iz * jz;
        double d = iSqr * jSqr - ij * ij;
        if (d <= 9.999999999999998E-15 * iSqr * jSqr) {
            return false;
        }
        double p = spherePolyhedronA.generatrixRadiusSquare - spherePolyhedronB.generatrixRadiusSquare + iSqr;
        double q = spherePolyhedronA.generatrixRadiusSquare - spherePolyhedronC.generatrixRadiusSquare + jSqr;
        double dInv = 1.0 / d;
        double dInvHalf = 0.5 * dInv;
        double a = (p * jSqr - q * ij) * dInvHalf;
        double b = (q * iSqr - p * ij) * dInvHalf;
        double xM = a * ix + b * jx;
        double yM = a * iy + b * jy;
        double zM = a * iz + b * jz;
        double w = (spherePolyhedronA.generatrixRadiusSquare - (xM * xM + yM * yM + zM * zM)) * dInv;
        if (w < 0.0) {
            return false;
        }
        double c = Math.sqrt(w);
        double kxMutilpliedByC = (iy * jz - iz * jy) * c;
        double kyMultipliedByC = (iz * jx - ix * jz) * c;
        double kzMultipliedByC = (ix * jy - iy * jx) * c;
        double xMFinal = x + xM;
        double yMFinal = y + yM;
        double zMFinal = z + zM;
        result1.setCommonXYZ(xMFinal - kxMutilpliedByC, yMFinal - kyMultipliedByC, zMFinal - kzMultipliedByC);
        result2.setCommonXYZ(xMFinal + kxMutilpliedByC, yMFinal + kyMultipliedByC, zMFinal + kzMultipliedByC);
        return true;
    }
}

