/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.objects;

import java.util.Arrays;
import java.util.List;
import net.algart.arrays.TooLargeArrayException;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedraIntersection;

public final class SpherePolyhedraIntersectionsList {
    private static final SpherePolyhedraIntersection[] EMPTY_SPHERE_POLYHEDRA_INTERSECTIONS = new SpherePolyhedraIntersection[0];
    int n = 0;
    private SpherePolyhedraIntersection[] intersections = EMPTY_SPHERE_POLYHEDRA_INTERSECTIONS;

    public static SpherePolyhedraIntersectionsList of(SpherePolyhedraIntersection ... intersections) {
        SpherePolyhedraIntersectionsList result = new SpherePolyhedraIntersectionsList();
        for (SpherePolyhedraIntersection intersection : intersections) {
            result.add(intersection);
        }
        return result;
    }

    public int size() {
        return this.n;
    }

    public void add(SpherePolyhedraIntersection intersection) {
        this.ensureCapacity(this.n + 1);
        this.intersections[this.n] = intersection;
        ++this.n;
    }

    public SpherePolyhedraIntersection get(int index) {
        this.checkIndex(index);
        return this.intersections[index];
    }

    public void set(int index, SpherePolyhedraIntersection intersection) {
        this.checkIndex(index);
        this.intersections[index] = intersection;
    }

    public List<SpherePolyhedraIntersection> asList() {
        return Arrays.asList(this.intersections).subList(0, this.n);
    }

    public String toString() {
        return this.asList().toString();
    }

    void clear() {
        this.n = 0;
    }

    void allocateAfterEnd(int numberOfExtraElements) {
        if (numberOfExtraElements < 0) {
            throw new IllegalArgumentException("Negative numberOfExtraElements");
        }
        this.ensureCapacity(this.n + numberOfExtraElements);
        for (int k = 0; k < numberOfExtraElements; ++k) {
            if (this.intersections[this.n + k] != null) continue;
            this.intersections[this.n + k] = new SpherePolyhedraIntersection();
        }
    }

    void increaseSize(int numberOfExtraElements) {
        if (numberOfExtraElements < 0) {
            throw new IllegalArgumentException("Negative numberOfExtraElements");
        }
        this.n += numberOfExtraElements;
    }

    SpherePolyhedraIntersection getUnchecked(int index) {
        return this.intersections[index];
    }

    void compactForExternalUsage() {
        if (this.intersections.length > this.n) {
            this.intersections = Arrays.copyOf(this.intersections, this.n);
        }
    }

    private void ensureCapacity(int newUnsignedNumberOfIntersection) {
        if (SpherePolyhedraIntersectionsList.unsigned(newUnsignedNumberOfIntersection) > (long)this.intersections.length) {
            long newLength = Math.max(16L, Math.max(SpherePolyhedraIntersectionsList.unsigned(newUnsignedNumberOfIntersection), Math.min(Integer.MAX_VALUE, 2L * (long)this.intersections.length)));
            if (newLength > Integer.MAX_VALUE) {
                throw new TooLargeArrayException("Too large array required for building intersections list: cannot allocate " + newLength + " >= 2147483647 elements");
            }
            this.intersections = Arrays.copyOf(this.intersections, (int)newLength);
        }
    }

    static long unsigned(int value) {
        return (long)value & 0xFFFFFFFFL;
    }

    private void checkIndex(int k) {
        if (k < 0 || k >= this.n) {
            throw new IndexOutOfBoundsException("Index of intersection " + k + " is out of range 0.." + (this.n - 1));
        }
    }
}

