/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.objects;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;
import net.algart.arrays.JArrays;
import net.algart.arrays.TooLargeArrayException;
import net.algart.math.RectangularArea;
import net.algart.math.geometry.Orthonormal3DBasis;
import net.algart.model3d.spherepolyhedra.objects.GeneratrixSet;
import net.algart.model3d.spherepolyhedra.objects.GeneratrixSphere;
import net.algart.model3d.spherepolyhedra.objects.SerializedSpherePolyhedra;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrion;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedron;

public final class SpherePolyhedra
implements Cloneable {
    public static final int SERIALIZED_MAGIC_WORD = 1397961008;
    public static final int SERIALIZED_STARTING_DATA_OFFSET = 3;
    public static final int MAX_NUMBER_OF_SPHERE_POLYHEDRA = 0x1FFFFEFF;
    private static final int MAX_NUMBER_OF_OBJECTS = 0x1FFFFEFF;
    int numberOfObjects = 0;
    int numberOfSpherePolyhedra = 0;
    private int generatrixSetsLength = 0;
    double[] xyzr = JArrays.EMPTY_DOUBLES;
    private int[] generatrixSetsOffsets = JArrays.EMPTY_INTS;
    private int[] numberOfGeneratrixSegments = JArrays.EMPTY_INTS;
    private int[] generatrixSets = JArrays.EMPTY_INTS;
    private long[] kindIds = JArrays.EMPTY_LONGS;
    private int[] containingSpherePolyhedrionIndexes = JArrays.EMPTY_INTS;
    private int[] spherePolyhedrionFirstIndexes = JArrays.EMPTY_INTS;
    private double[] minX;
    private double[] maxX;
    private double[] minY;
    private double[] maxY;
    private double[] minZ;
    private double[] maxZ;
    private double[] containingSphereRadius;
    private double[] volume;
    private double maxContainingSphereRadius;
    private double summaryVolume;
    private RectangularArea containingAllParallelepiped = null;
    private final SpherePolyhedron workMemoryForContainingSphereRadius = new SpherePolyhedron();

    private SpherePolyhedra() {
        this.reinitializeGlobalCaches();
    }

    public static SpherePolyhedra newEmpty() {
        return new SpherePolyhedra();
    }

    public static SpherePolyhedra deserialize(SerializedSpherePolyhedra serialized) {
        int n;
        Objects.requireNonNull(serialized, "Null serialized form");
        serialized.checkIntegrity();
        SpherePolyhedra r = new SpherePolyhedra();
        r.numberOfSpherePolyhedra = n = serialized.numberOfSpherePolyhedra();
        if (serialized.xyzr != null) {
            r.xyzr = (double[])serialized.xyzr.clone();
        } else if (serialized.xyz != null) {
            r.xyzr = new double[4 * n];
            int k = 0;
            int dispXyzr = 0;
            int dispXyz = 0;
            while (k < n) {
                r.xyzr[dispXyzr] = serialized.xyz[dispXyz];
                r.xyzr[dispXyzr + 1] = serialized.xyz[dispXyz + 1];
                r.xyzr[dispXyzr + 2] = serialized.xyz[dispXyz + 2];
                r.xyzr[dispXyzr + 3] = Double.NaN;
                ++k;
                dispXyzr += 4;
                dispXyz += 3;
            }
        }
        r.generatrixSetsOffsets = new int[n];
        r.numberOfGeneratrixSegments = new int[n];
        if (serialized.serializedGeneratrixSets != null && serialized.serializedGeneratrixSets.length > 0) {
            r.generatrixSets = Arrays.copyOfRange(serialized.serializedGeneratrixSets, 3, serialized.serializedGeneratrixSets.length);
        }
        int offset = 0;
        int numberOfObjects = 0;
        for (int k = 0; k < n; ++k) {
            assert (offset <= r.generatrixSets.length) : "GeneratrixSet.checkSerializedData did not check returned offset correctly";
            if (offset == r.generatrixSets.length) {
                Arrays.fill(r.generatrixSetsOffsets, k, n, offset);
                Arrays.fill(r.numberOfGeneratrixSegments, k, n, 0);
                offset += 3;
                numberOfObjects += n - k;
                break;
            }
            r.generatrixSetsOffsets[k] = offset;
            int newOffset = GeneratrixSet.checkSerializedData(r.generatrixSets, offset, false);
            r.numberOfGeneratrixSegments[k] = GeneratrixSet.deserializeNumberOfSegmens(r.generatrixSets, offset);
            if (!GeneratrixSet.deserializeContinuationFlag(r.generatrixSets, offset)) {
                ++numberOfObjects;
            }
            offset = newOffset;
        }
        if (offset != r.generatrixSets.length) {
            r.generatrixSets = Arrays.copyOf(r.generatrixSets, offset);
        }
        r.generatrixSetsLength = offset;
        r.spherePolyhedrionFirstIndexes = new int[numberOfObjects];
        r.containingSpherePolyhedrionIndexes = new int[n];
        int objectsCount = 0;
        for (int k = 0; k < n; ++k) {
            if (Double.isNaN(r.xyzr[4 * k + 3])) {
                r.xyzr[4 * k + 3] = GeneratrixSet.deserializeRadius(r.generatrixSets, r.generatrixSetsOffsets[k]);
            } else {
                GeneratrixSphere.checkRadius(r.xyzr[4 * k + 3]);
            }
            r.containingSpherePolyhedrionIndexes[k] = objectsCount;
            if (GeneratrixSet.deserializeContinuationFlag(r.generatrixSets, r.generatrixSetsOffsets[k])) continue;
            r.spherePolyhedrionFirstIndexes[objectsCount] = k;
            ++objectsCount;
        }
        assert (objectsCount == numberOfObjects);
        r.numberOfObjects = numberOfObjects;
        r.kindIds = new long[n];
        if (serialized.kindIds != null) {
            System.arraycopy(serialized.kindIds, 0, r.kindIds, 0, Math.min(serialized.kindIds.length, n));
        }
        r.expandGlobalCaches();
        return r;
    }

    public SerializedSpherePolyhedra serialize() {
        return this.serialize(null);
    }

    public SerializedSpherePolyhedra serialize(SerializedSpherePolyhedra serialized) {
        if (serialized == null) {
            serialized = new SerializedSpherePolyhedra();
        }
        int[] serializedGeneratrixSets = new int[this.generatrixSetsLength + 3];
        serializedGeneratrixSets[0] = 1397961008;
        System.arraycopy(this.generatrixSets, 0, serializedGeneratrixSets, 3, this.generatrixSetsLength);
        return serialized.setXyzr(Arrays.copyOf(this.xyzr, 4 * this.numberOfSpherePolyhedra)).setSerializedGeneratrixSets(serializedGeneratrixSets).setKindIds(Arrays.copyOf(this.kindIds, this.numberOfSpherePolyhedra));
    }

    public void clear() {
        this.numberOfObjects = 0;
        this.numberOfSpherePolyhedra = 0;
        this.generatrixSetsLength = 0;
        this.maxContainingSphereRadius = 0.0;
        this.summaryVolume = 0.0;
        this.containingAllParallelepiped = null;
    }

    public boolean isEmpty() {
        return this.numberOfSpherePolyhedra == 0;
    }

    public int numberOfObjects() {
        return this.numberOfObjects;
    }

    public int numberOfSpherePolyhedra() {
        assert (this.numberOfObjects <= this.numberOfSpherePolyhedra);
        return this.numberOfSpherePolyhedra;
    }

    public double getCenterX(int spherePolyhedronIndex) {
        this.checkSpherePolyhedronIndex(spherePolyhedronIndex);
        return this.xyzr[4 * spherePolyhedronIndex];
    }

    public double getCenterY(int spherePolyhedronIndex) {
        this.checkSpherePolyhedronIndex(spherePolyhedronIndex);
        return this.xyzr[4 * spherePolyhedronIndex + 1];
    }

    public double getCenterZ(int spherePolyhedronIndex) {
        this.checkSpherePolyhedronIndex(spherePolyhedronIndex);
        return this.xyzr[4 * spherePolyhedronIndex + 2];
    }

    public double getGeneratrixSphereRadius(int spherePolyhedronIndex) {
        this.checkSpherePolyhedronIndex(spherePolyhedronIndex);
        return this.xyzr[4 * spherePolyhedronIndex + 3];
    }

    public GeneratrixSet getGeneratrixSet(int spherePolyhedronIndex) {
        return this.getGeneratrixSet(spherePolyhedronIndex, false);
    }

    public GeneratrixSet getGeneratrixSet(int spherePolyhedronIndex, boolean skipGeneratrixSphere) {
        return this.getGeneratrixSet(null, spherePolyhedronIndex, skipGeneratrixSphere).immutable();
    }

    public long getKindId(int spherePolyhedronIndex) {
        this.checkSpherePolyhedronIndex(spherePolyhedronIndex);
        return this.kindIds[spherePolyhedronIndex];
    }

    public long getObjectKindId(int objectIndex) {
        this.checkSpherePolyhedrionIndex(objectIndex);
        return this.kindIds[this.spherePolyhedrionFirstIndexes[objectIndex]];
    }

    public SpherePolyhedron getSpherePolyhedron(int spherePolyhedronIndex) {
        return this.getSpherePolyhedron(null, spherePolyhedronIndex);
    }

    public long[] getAllKindIds() {
        return Arrays.copyOfRange(this.kindIds, 0, this.numberOfSpherePolyhedra);
    }

    public int[] getAllNumbersOfGeneratrixSegments() {
        return Arrays.copyOfRange(this.numberOfGeneratrixSegments, 0, this.numberOfSpherePolyhedra);
    }

    public int[] getAllContainingObjectIndexes() {
        return Arrays.copyOfRange(this.containingSpherePolyhedrionIndexes, 0, this.numberOfSpherePolyhedra);
    }

    public int[] getAllFirstSpherePolyhedronIndexesInObjects() {
        return Arrays.copyOfRange(this.spherePolyhedrionFirstIndexes, 0, this.numberOfObjects);
    }

    public int numberOfGeneratrixSegments(int spherePolyhedronIndex) {
        this.checkSpherePolyhedronIndex(spherePolyhedronIndex);
        return this.numberOfGeneratrixSegments[spherePolyhedronIndex];
    }

    public int containingObjectIndex(int spherePolyhedronIndex) {
        if (spherePolyhedronIndex == this.numberOfSpherePolyhedra) {
            return this.numberOfObjects;
        }
        this.checkSpherePolyhedronIndex(spherePolyhedronIndex);
        return this.containingSpherePolyhedrionIndexes[spherePolyhedronIndex];
    }

    public int firstSpherePolyhedronIndexInObject(int objectIndex) {
        if (objectIndex == this.numberOfObjects) {
            return this.numberOfSpherePolyhedra;
        }
        this.checkSpherePolyhedrionIndex(objectIndex);
        return this.spherePolyhedrionFirstIndexes[objectIndex];
    }

    public int numberOfElementsInObject(int objectIndex) {
        this.checkSpherePolyhedrionIndex(objectIndex);
        int lastIndex = this.firstSpherePolyhedronIndexInObject(objectIndex + 1);
        return lastIndex - this.spherePolyhedrionFirstIndexes[objectIndex];
    }

    public boolean isFirstIndexInObject(int spherePolyhedronIndex) {
        this.checkSpherePolyhedronIndex(spherePolyhedronIndex);
        int containingSpherePolyhedrionIndex = this.containingSpherePolyhedrionIndexes[spherePolyhedronIndex];
        return this.spherePolyhedrionFirstIndexes[containingSpherePolyhedrionIndex] == spherePolyhedronIndex;
    }

    public SpherePolyhedrion getObject(int objectIndex) {
        return this.getObject(null, objectIndex);
    }

    public boolean isSphere(int spherePolyhedronIndex) {
        this.checkSpherePolyhedronIndex(spherePolyhedronIndex);
        return this.numberOfGeneratrixSegments[spherePolyhedronIndex] == 0;
    }

    public double minX(int spherePolyhedronIndex) {
        this.checkSpherePolyhedronIndex(spherePolyhedronIndex);
        this.renewSimple(spherePolyhedronIndex);
        return this.minX[spherePolyhedronIndex];
    }

    public double maxX(int spherePolyhedronIndex) {
        this.checkSpherePolyhedronIndex(spherePolyhedronIndex);
        this.renewSimple(spherePolyhedronIndex);
        return this.maxX[spherePolyhedronIndex];
    }

    public double minY(int spherePolyhedronIndex) {
        this.checkSpherePolyhedronIndex(spherePolyhedronIndex);
        this.renewSimple(spherePolyhedronIndex);
        return this.minY[spherePolyhedronIndex];
    }

    public double maxY(int spherePolyhedronIndex) {
        this.checkSpherePolyhedronIndex(spherePolyhedronIndex);
        this.renewSimple(spherePolyhedronIndex);
        return this.maxY[spherePolyhedronIndex];
    }

    public double minZ(int spherePolyhedronIndex) {
        this.checkSpherePolyhedronIndex(spherePolyhedronIndex);
        this.renewSimple(spherePolyhedronIndex);
        return this.minZ[spherePolyhedronIndex];
    }

    public double maxZ(int spherePolyhedronIndex) {
        this.checkSpherePolyhedronIndex(spherePolyhedronIndex);
        this.renewSimple(spherePolyhedronIndex);
        return this.maxZ[spherePolyhedronIndex];
    }

    public double containingSphereRadius(int spherePolyhedronIndex) {
        this.checkSpherePolyhedronIndex(spherePolyhedronIndex);
        double r = this.xyzr[4 * spherePolyhedronIndex + 3];
        if (this.numberOfGeneratrixSegments[spherePolyhedronIndex] == 0) {
            return r;
        }
        if (Double.isNaN(this.containingSphereRadius[spherePolyhedronIndex])) {
            int offset = this.generatrixSetsOffsets[spherePolyhedronIndex];
            this.containingSphereRadius[spherePolyhedronIndex] = GeneratrixSet.containingSphereRadiusForSerialized(r, this.generatrixSets, offset, this.workMemoryForContainingSphereRadius);
        }
        return this.containingSphereRadius[spherePolyhedronIndex];
    }

    public double maxContainingSphereRadiusForObject(int objectIndex) {
        this.checkSpherePolyhedrionIndex(objectIndex);
        double result = Double.NEGATIVE_INFINITY;
        int from = this.firstSpherePolyhedronIndexInObject(objectIndex);
        int to = this.firstSpherePolyhedronIndexInObject(objectIndex + 1);
        for (int k = from; k < to; ++k) {
            double r = this.containingSphereRadius(k);
            if (!(r > result)) continue;
            result = r;
        }
        return result;
    }

    public double volume(int spherePolyhedronIndex) {
        this.checkSpherePolyhedronIndex(spherePolyhedronIndex);
        this.renew(spherePolyhedronIndex);
        return this.volume[spherePolyhedronIndex];
    }

    public double maxContainingSphereRadius() {
        if (Double.isNaN(this.maxContainingSphereRadius)) {
            double result = 0.0;
            for (int k = 0; k < this.numberOfSpherePolyhedra; ++k) {
                result = Math.max(result, this.containingSphereRadius(k));
            }
            this.maxContainingSphereRadius = result;
        }
        return this.maxContainingSphereRadius;
    }

    public double summaryVolume() {
        if (Double.isNaN(this.summaryVolume)) {
            double result = 0.0;
            for (int k = 0; k < this.numberOfSpherePolyhedra; ++k) {
                result += this.volume(k);
            }
            this.summaryVolume = result;
        }
        return this.summaryVolume;
    }

    public RectangularArea containingAllParallelepiped() {
        if (this.numberOfSpherePolyhedra == 0) {
            return null;
        }
        if (this.containingAllParallelepiped == null) {
            double minX = Double.POSITIVE_INFINITY;
            double maxX = Double.NEGATIVE_INFINITY;
            double minY = Double.POSITIVE_INFINITY;
            double maxY = Double.NEGATIVE_INFINITY;
            double minZ = Double.POSITIVE_INFINITY;
            double maxZ = Double.NEGATIVE_INFINITY;
            for (int k = 0; k < this.numberOfSpherePolyhedra; ++k) {
                minX = Math.min(minX, this.minX(k));
                maxX = Math.max(maxX, this.maxX(k));
                minY = Math.min(minY, this.minY(k));
                maxY = Math.max(maxY, this.maxY(k));
                minZ = Math.min(minZ, this.minZ(k));
                maxZ = Math.max(maxZ, this.maxZ(k));
            }
            this.containingAllParallelepiped = RectangularArea.valueOf((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
        }
        return this.containingAllParallelepiped;
    }

    public RectangularArea containingAllParallelepiped(Orthonormal3DBasis rotationBasis, double scale) {
        Objects.requireNonNull(rotationBasis, "Null rotation basis");
        if (this.numberOfSpherePolyhedra == 0) {
            return null;
        }
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        GeneratrixSet generatrixSet = new GeneratrixSet();
        for (int p = 0; p < this.numberOfSpherePolyhedra; ++p) {
            this.getGeneratrixSet(generatrixSet, p, false);
            double centerX = this.xyzr[4 * p];
            double centerY = this.xyzr[4 * p + 1];
            double centerZ = this.xyzr[4 * p + 2];
            double rotatedX = rotationBasis.x(centerX, centerY, centerZ);
            double rotatedY = rotationBasis.y(centerX, centerY, centerZ);
            double rotatedZ = rotationBasis.z(centerX, centerY, centerZ);
            double sumAbsX = 0.0;
            double sumAbsY = 0.0;
            double sumAbsZ = 0.0;
            for (int l = 0; l < generatrixSet.numberOfGeneratrixSegments; ++l) {
                double i = generatrixSet.generatrixSegmentX(l);
                double j = generatrixSet.generatrixSegmentY(l);
                double k = generatrixSet.generatrixSegmentZ(l);
                sumAbsX += Math.abs(rotationBasis.x(i, j, k));
                sumAbsY += Math.abs(rotationBasis.y(i, j, k));
                sumAbsZ += Math.abs(rotationBasis.z(i, j, k));
            }
            double r = generatrixSet.generatrixSphereRadius();
            double minRotatedX = rotatedX - sumAbsX - r;
            double maxRotatedX = rotatedX + sumAbsX + r;
            double minRotatedY = rotatedY - sumAbsY - r;
            double maxRotatedY = rotatedY + sumAbsY + r;
            double minRotatedZ = rotatedZ - sumAbsZ - r;
            double maxRotatedZ = rotatedZ + sumAbsZ + r;
            if (minRotatedX < minX) {
                minX = minRotatedX;
            }
            if (maxRotatedX > maxX) {
                maxX = maxRotatedX;
            }
            if (minRotatedY < minY) {
                minY = minRotatedY;
            }
            if (maxRotatedY > maxY) {
                maxY = maxRotatedY;
            }
            if (minRotatedZ < minZ) {
                minZ = minRotatedZ;
            }
            if (!(maxRotatedZ > maxZ)) continue;
            maxZ = maxRotatedZ;
        }
        return RectangularArea.valueOf((double)(scale * minX), (double)(scale * minY), (double)(scale * minZ), (double)(scale * maxX), (double)(scale * maxY), (double)(scale * maxZ));
    }

    public void add(SpherePolyhedron spherePolyhedron) {
        this.add(spherePolyhedron, false);
    }

    public void add(SpherePolyhedron spherePolyhedron, boolean continuationOfUnion) {
        Objects.requireNonNull(spherePolyhedron, "Null sphere-polyhedron");
        GeneratrixSet generatrixSet = spherePolyhedron.generatrixSet();
        int serializedLength = GeneratrixSet.SerializedForm.dataLength(generatrixSet);
        this.ensureCapacityIncrement(continuationOfUnion ? 0L : 1L, 1L, serializedLength);
        this.xyzr[4 * this.numberOfSpherePolyhedra] = spherePolyhedron.centerX();
        this.xyzr[4 * this.numberOfSpherePolyhedra + 1] = spherePolyhedron.centerY();
        this.xyzr[4 * this.numberOfSpherePolyhedra + 2] = spherePolyhedron.centerZ();
        this.xyzr[4 * this.numberOfSpherePolyhedra + 3] = generatrixSet.generatrixSphereRadius();
        this.kindIds[this.numberOfSpherePolyhedra] = spherePolyhedron.kindId();
        this.generatrixSetsOffsets[this.numberOfSpherePolyhedra] = this.generatrixSetsLength;
        this.numberOfGeneratrixSegments[this.numberOfSpherePolyhedra] = generatrixSet.numberOfGeneratrixSegments();
        generatrixSet.serializeData(this.generatrixSets, this.generatrixSetsLength, continuationOfUnion);
        this.renew(this.numberOfSpherePolyhedra, spherePolyhedron);
        this.updateGlobal(spherePolyhedron);
        this.containingSpherePolyhedrionIndexes[this.numberOfSpherePolyhedra] = this.numberOfObjects;
        if (!continuationOfUnion) {
            this.spherePolyhedrionFirstIndexes[this.numberOfObjects] = this.numberOfSpherePolyhedra;
            ++this.numberOfObjects;
        }
        ++this.numberOfSpherePolyhedra;
        this.generatrixSetsLength += serializedLength;
    }

    public void add(SpherePolyhedrion spherePolyhedrion) {
        Objects.requireNonNull(spherePolyhedrion, "Null sphere-polyhedrion");
        for (int k = 0; k < spherePolyhedrion.n; ++k) {
            this.add(spherePolyhedrion.elements[k], k > 0);
        }
    }

    public void addObjects(SpherePolyhedra spherePolyhedra) {
        Objects.requireNonNull(spherePolyhedra, "Null added sphere-polyhedra");
        this.addObjects(spherePolyhedra, 0, spherePolyhedra.numberOfObjects());
    }

    public void addObjects(SpherePolyhedra spherePolyhedra, int objectFrom, int objectTo) {
        Objects.requireNonNull(spherePolyhedra, "Null added sphere-polyhedra");
        spherePolyhedra.checkSpherePolyhedrionIndexRange(objectFrom, objectTo);
        if (objectFrom == objectTo) {
            return;
        }
        int spherePolyhedraFrom = spherePolyhedra.firstSpherePolyhedronIndexInObject(objectFrom);
        int spherePolyhedraTo = spherePolyhedra.firstSpherePolyhedronIndexInObject(objectTo);
        assert (spherePolyhedraFrom < spherePolyhedraTo) : "sphere-polyhedrions cannot be empty";
        int generatrixSetsOffsetFrom = spherePolyhedra.generatrixSetsOffset(spherePolyhedraFrom);
        int generatrixSetsOffsetTo = spherePolyhedra.generatrixSetsOffset(spherePolyhedraTo);
        int spherePolyhedrionCount = objectTo - objectFrom;
        int spherePolyhedraCount = spherePolyhedraTo - spherePolyhedraFrom;
        int generatrixSetsLengthIncrement = generatrixSetsOffsetTo - generatrixSetsOffsetFrom;
        this.reinitializeGlobalCaches();
        this.ensureCapacityIncrement(spherePolyhedrionCount, spherePolyhedraCount, generatrixSetsLengthIncrement);
        System.arraycopy(spherePolyhedra.xyzr, 4 * spherePolyhedraFrom, this.xyzr, 4 * this.numberOfSpherePolyhedra, 4 * spherePolyhedraCount);
        System.arraycopy(spherePolyhedra.kindIds, spherePolyhedraFrom, this.kindIds, this.numberOfSpherePolyhedra, spherePolyhedraCount);
        System.arraycopy(spherePolyhedra.generatrixSets, generatrixSetsOffsetFrom, this.generatrixSets, this.generatrixSetsLength, generatrixSetsLengthIncrement);
        for (int k = 0; k < spherePolyhedraCount; ++k) {
            this.generatrixSetsOffsets[this.numberOfSpherePolyhedra + k] = this.generatrixSetsLength + spherePolyhedra.generatrixSetsOffsets[spherePolyhedraFrom + k];
        }
        System.arraycopy(spherePolyhedra.numberOfGeneratrixSegments, spherePolyhedraFrom, this.numberOfGeneratrixSegments, this.numberOfSpherePolyhedra, spherePolyhedraCount);
        System.arraycopy(spherePolyhedra.containingSpherePolyhedrionIndexes, spherePolyhedraFrom, this.containingSpherePolyhedrionIndexes, this.numberOfSpherePolyhedra, spherePolyhedraCount);
        System.arraycopy(spherePolyhedra.spherePolyhedrionFirstIndexes, objectFrom, this.spherePolyhedrionFirstIndexes, this.numberOfObjects, spherePolyhedrionCount);
        this.numberOfObjects += spherePolyhedrionCount;
        this.numberOfSpherePolyhedra += spherePolyhedraCount;
        this.generatrixSetsLength += generatrixSetsLengthIncrement;
    }

    public void removeObjects(final IntPredicate conditionForRemoving) {
        this.removeObjects(new RemovingCondition(){

            @Override
            public boolean acceptRemoving(int objectIndex, SpherePolyhedrion objectToRemove) {
                return conditionForRemoving.test(objectIndex);
            }

            @Override
            public boolean requiresObjectForDecision() {
                return false;
            }
        });
    }

    public void removeObjects(RemovingCondition conditionForRemoving) {
        int objectIndex2;
        Objects.requireNonNull(conditionForRemoving, "Null condition");
        boolean[] needToRetain = new boolean[this.numberOfObjects];
        if (conditionForRemoving.requiresObjectForDecision()) {
            SpherePolyhedrion workObject = new SpherePolyhedrion();
            for (objectIndex2 = 0; objectIndex2 < this.numberOfObjects; ++objectIndex2) {
                this.getObject(workObject, objectIndex2);
                needToRetain[objectIndex2] = !conditionForRemoving.acceptRemoving(objectIndex2, workObject);
            }
        } else {
            IntStream.range(0, this.numberOfObjects).parallel().forEach(objectIndex -> {
                needToRetain[objectIndex] = !conditionForRemoving.acceptRemoving(objectIndex, null);
            });
        }
        boolean needToRetainAll = true;
        for (objectIndex2 = 0; objectIndex2 < this.numberOfObjects; ++objectIndex2) {
            needToRetainAll &= needToRetain[objectIndex2];
        }
        if (needToRetainAll) {
            return;
        }
        int newGeneratrixSetsLength = 0;
        int newNumberOfObjects = 0;
        int newNumberOfSpherePolyhedra = 0;
        int newXyzrIndex = 0;
        this.reinitializeGlobal();
        for (int objectIndex3 = 0; objectIndex3 < this.numberOfObjects; ++objectIndex3) {
            if (!needToRetain[objectIndex3]) continue;
            int from = this.firstSpherePolyhedronIndexInObject(objectIndex3);
            int to = this.firstSpherePolyhedronIndexInObject(objectIndex3 + 1);
            int xyzrIndex = 4 * from;
            for (int k = from; k < to; ++k) {
                this.xyzr[newXyzrIndex++] = this.xyzr[xyzrIndex++];
                this.xyzr[newXyzrIndex++] = this.xyzr[xyzrIndex++];
                this.xyzr[newXyzrIndex++] = this.xyzr[xyzrIndex++];
                this.xyzr[newXyzrIndex++] = this.xyzr[xyzrIndex++];
                this.kindIds[newNumberOfSpherePolyhedra] = this.kindIds[k];
                int offset = this.generatrixSetsOffsets[k];
                int newOffset = newGeneratrixSetsLength;
                int offsetTo = this.generatrixSetsOffset(k + 1);
                while (offset < offsetTo) {
                    this.generatrixSets[newGeneratrixSetsLength++] = this.generatrixSets[offset++];
                }
                this.generatrixSetsOffsets[newNumberOfSpherePolyhedra] = newOffset;
                this.numberOfGeneratrixSegments[newNumberOfSpherePolyhedra] = this.numberOfGeneratrixSegments[k];
                this.containingSpherePolyhedrionIndexes[newNumberOfSpherePolyhedra] = this.containingSpherePolyhedrionIndexes[k];
                this.copySpherePolyhedronCache(this, k, newNumberOfSpherePolyhedra);
                ++newNumberOfSpherePolyhedra;
            }
            this.spherePolyhedrionFirstIndexes[newNumberOfObjects] = this.spherePolyhedrionFirstIndexes[objectIndex3];
            ++newNumberOfObjects;
        }
        this.numberOfObjects = newNumberOfObjects;
        this.numberOfSpherePolyhedra = newNumberOfSpherePolyhedra;
        this.generatrixSetsLength = newGeneratrixSetsLength;
    }

    public SpherePolyhedra clone() {
        SpherePolyhedra result;
        try {
            result = (SpherePolyhedra)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
        result.xyzr = Arrays.copyOf(this.xyzr, 4 * this.numberOfSpherePolyhedra);
        result.generatrixSetsOffsets = Arrays.copyOf(this.generatrixSetsOffsets, this.numberOfSpherePolyhedra);
        result.numberOfGeneratrixSegments = Arrays.copyOf(this.numberOfGeneratrixSegments, this.numberOfSpherePolyhedra);
        result.generatrixSets = Arrays.copyOf(this.generatrixSets, this.generatrixSetsLength);
        result.kindIds = Arrays.copyOf(this.kindIds, this.numberOfSpherePolyhedra);
        result.containingSpherePolyhedrionIndexes = Arrays.copyOf(this.containingSpherePolyhedrionIndexes, this.numberOfSpherePolyhedra);
        result.spherePolyhedrionFirstIndexes = Arrays.copyOf(this.spherePolyhedrionFirstIndexes, this.numberOfObjects);
        result.minX = Arrays.copyOf(this.minX, this.numberOfSpherePolyhedra);
        result.maxX = Arrays.copyOf(this.maxX, this.numberOfSpherePolyhedra);
        result.minY = Arrays.copyOf(this.minY, this.numberOfSpherePolyhedra);
        result.maxY = Arrays.copyOf(this.maxY, this.numberOfSpherePolyhedra);
        result.minZ = Arrays.copyOf(this.minZ, this.numberOfSpherePolyhedra);
        result.maxZ = Arrays.copyOf(this.maxZ, this.numberOfSpherePolyhedra);
        result.containingSphereRadius = Arrays.copyOf(this.containingSphereRadius, this.numberOfSpherePolyhedra);
        result.volume = Arrays.copyOf(this.volume, this.numberOfSpherePolyhedra);
        return result;
    }

    public String toString() {
        return "array of " + (this.numberOfObjects == this.numberOfSpherePolyhedra ? this.numberOfObjects + " sphere-polyhedra" : this.numberOfObjects + " unions of " + this.numberOfSpherePolyhedra + " sphere-polyhedra") + " (containing parallelepiped " + String.valueOf(this.containingAllParallelepiped == null ? "n/a" : this.containingAllParallelepiped) + ", summary volume " + String.valueOf(Double.isNaN(this.summaryVolume) ? "n/a" : Double.valueOf(this.summaryVolume)) + ")";
    }

    int generatrixSetsOffset(int spherePolyhedronIndex) {
        if (spherePolyhedronIndex == this.numberOfSpherePolyhedra) {
            return this.generatrixSetsLength;
        }
        this.checkSpherePolyhedronIndex(spherePolyhedronIndex);
        return this.generatrixSetsOffsets[spherePolyhedronIndex];
    }

    GeneratrixSet getGeneratrixSet(GeneratrixSet result, int k, boolean skipGeneratrixSphere) {
        this.checkSpherePolyhedronIndex(k);
        int offset = this.generatrixSetsOffsets[k];
        double radius = skipGeneratrixSphere ? 0.0 : this.xyzr[4 * k + 3];
        result = GeneratrixSet.deserialize(result, radius, this.generatrixSets, offset);
        if (!skipGeneratrixSphere) {
            this.renewSimple(k, result);
        }
        return result;
    }

    SpherePolyhedron getSpherePolyhedron(SpherePolyhedron result, int spherePolyhedronIndex) {
        return this.getMinkowskiSum(result, spherePolyhedronIndex, SpherePolyhedron.ZERO);
    }

    SpherePolyhedrion getObject(SpherePolyhedrion result, int objectIndex) {
        int numberOfElements = this.numberOfElementsInObject(objectIndex);
        if (result == null) {
            result = new SpherePolyhedrion();
        }
        result.setNumberOfElements(numberOfElements);
        int j = 0;
        int i = this.firstSpherePolyhedronIndexInObject(objectIndex);
        while (j < numberOfElements) {
            this.getSpherePolyhedron(result.elements[j], i);
            ++j;
            ++i;
        }
        result.rebuild();
        return result;
    }

    SpherePolyhedron getMinkowskiSum(SpherePolyhedron result, int spherePolyhedronIndex, SpherePolyhedron added) {
        this.checkSpherePolyhedronIndex(spherePolyhedronIndex);
        if (result == null) {
            result = new SpherePolyhedron();
        }
        this.getGeneratrixSet(result.generatrixSet, spherePolyhedronIndex, false);
        result.setCenter(this.xyzr[4 * spherePolyhedronIndex], this.xyzr[4 * spherePolyhedronIndex + 1], this.xyzr[4 * spherePolyhedronIndex + 2]);
        result.setKindId(this.kindIds[spherePolyhedronIndex]);
        result.minkowskiAdd(added);
        if (added.isZero()) {
            result.rebuild();
            this.renew(spherePolyhedronIndex, result);
        }
        return result;
    }

    private void ensureCapacityIncrement(long addedNumberOfObjects, long addedNumberOfSpherePolyhedra, long addedSerializedGeneratrixSetsLength) {
        this.ensureCapacity((long)this.numberOfObjects + addedNumberOfObjects, (long)this.numberOfSpherePolyhedra + addedNumberOfSpherePolyhedra, (long)this.generatrixSetsLength + addedSerializedGeneratrixSetsLength);
    }

    private void ensureCapacity(long newNumberOfObjects, long newNumberOfSpherePolyhedra, long newSerializedGeneratrixSetsLength) {
        int newLength;
        if (newNumberOfObjects > (long)this.spherePolyhedrionFirstIndexes.length) {
            newLength = SpherePolyhedra.increaseCapacity(newNumberOfObjects, this.generatrixSetsOffsets.length, 0x1FFFFEFF, "sphere-polyhedrions");
            this.spherePolyhedrionFirstIndexes = Arrays.copyOf(this.spherePolyhedrionFirstIndexes, newLength);
        }
        if (newNumberOfSpherePolyhedra > (long)this.generatrixSetsOffsets.length) {
            newLength = SpherePolyhedra.increaseCapacity(newNumberOfSpherePolyhedra, this.generatrixSetsOffsets.length, 0x1FFFFEFF, "sphere-polyhedra");
            this.xyzr = Arrays.copyOf(this.xyzr, 4 * newLength);
            this.generatrixSetsOffsets = Arrays.copyOf(this.generatrixSetsOffsets, newLength);
            this.numberOfGeneratrixSegments = Arrays.copyOf(this.numberOfGeneratrixSegments, newLength);
            this.kindIds = Arrays.copyOf(this.kindIds, newLength);
            this.containingSpherePolyhedrionIndexes = Arrays.copyOf(this.containingSpherePolyhedrionIndexes, newLength);
            this.expandGlobalCaches();
        }
        if (newSerializedGeneratrixSetsLength > (long)this.generatrixSets.length) {
            newLength = SpherePolyhedra.increaseCapacity(newSerializedGeneratrixSetsLength, this.generatrixSets.length, 2147483388, "integers for storing generatrices");
            this.generatrixSets = Arrays.copyOf(this.generatrixSets, newLength);
        }
    }

    private void expandGlobalCaches() {
        int newLength = this.xyzr.length / 4;
        this.minX = SpherePolyhedra.expandWithNaN(this.minX, newLength);
        this.maxX = SpherePolyhedra.expandWithNaN(this.maxX, newLength);
        this.minY = SpherePolyhedra.expandWithNaN(this.minY, newLength);
        this.maxY = SpherePolyhedra.expandWithNaN(this.maxY, newLength);
        this.minZ = SpherePolyhedra.expandWithNaN(this.minZ, newLength);
        this.maxZ = SpherePolyhedra.expandWithNaN(this.maxZ, newLength);
        this.containingSphereRadius = SpherePolyhedra.expandWithNaN(this.containingSphereRadius, newLength);
        this.volume = SpherePolyhedra.expandWithNaN(this.volume, newLength);
    }

    private void renewSimple(int k) {
        if (Double.isNaN(this.minX[k])) {
            this.getGeneratrixSet(k);
        }
    }

    private void renew(int k) {
        if (Double.isNaN(this.volume[k])) {
            this.getSpherePolyhedron(k);
        }
    }

    private void updateGlobal(SpherePolyhedron spherePolyhedron) {
        this.updateGlobal(spherePolyhedron.containingSphereRadius(), spherePolyhedron.volume(), spherePolyhedron.containingParallelepiped());
    }

    private void updateGlobal(double containingSphereRadius, double volume, RectangularArea containingParallelepiped) {
        this.maxContainingSphereRadius = Math.max(this.maxContainingSphereRadius, containingSphereRadius);
        this.summaryVolume += volume;
        this.containingAllParallelepiped = this.containingAllParallelepiped == null ? containingParallelepiped : this.containingAllParallelepiped.expand(containingParallelepiped);
    }

    private void reinitializeGlobalCaches() {
        this.reinitializeGlobal();
        this.minX = JArrays.EMPTY_DOUBLES;
        this.maxX = JArrays.EMPTY_DOUBLES;
        this.minY = JArrays.EMPTY_DOUBLES;
        this.maxY = JArrays.EMPTY_DOUBLES;
        this.minZ = JArrays.EMPTY_DOUBLES;
        this.maxZ = JArrays.EMPTY_DOUBLES;
        this.containingSphereRadius = JArrays.EMPTY_DOUBLES;
        this.volume = JArrays.EMPTY_DOUBLES;
        this.expandGlobalCaches();
    }

    private void reinitializeGlobal() {
        this.maxContainingSphereRadius = Double.NaN;
        this.summaryVolume = Double.NaN;
        this.containingAllParallelepiped = null;
    }

    private void renewSimple(int k, GeneratrixSet generatrixSet) {
        double x = this.xyzr[4 * k];
        double y = this.xyzr[4 * k + 1];
        double z = this.xyzr[4 * k + 2];
        this.minX[k] = x + generatrixSet.minX();
        this.maxX[k] = x + generatrixSet.maxX();
        this.minY[k] = y + generatrixSet.minY();
        this.maxY[k] = y + generatrixSet.maxY();
        this.minZ[k] = z + generatrixSet.minZ();
        this.maxZ[k] = z + generatrixSet.maxZ();
    }

    private void renew(int k, SpherePolyhedron spherePolyhedron) {
        if (Double.isNaN(this.volume[k])) {
            this.minX[k] = spherePolyhedron.minX();
            this.maxX[k] = spherePolyhedron.maxX();
            this.minY[k] = spherePolyhedron.minY();
            this.maxY[k] = spherePolyhedron.maxY();
            this.minZ[k] = spherePolyhedron.minZ();
            this.maxZ[k] = spherePolyhedron.maxZ();
            this.containingSphereRadius[k] = spherePolyhedron.containingSphereRadius();
            this.volume[k] = spherePolyhedron.volume();
        }
    }

    private void copySpherePolyhedronCache(SpherePolyhedra source, int sourceIndex, int destinationIndex) {
        int length = source.minX.length;
        assert (length == source.maxX.length);
        assert (length == source.minY.length);
        assert (length == source.maxY.length);
        assert (length == source.minZ.length);
        assert (length == source.maxZ.length);
        assert (length == source.containingSphereRadius.length);
        assert (length == source.volume.length);
        SpherePolyhedra.copyCacheValue(source.minX, sourceIndex, this.minX, destinationIndex);
        SpherePolyhedra.copyCacheValue(source.maxX, sourceIndex, this.maxX, destinationIndex);
        SpherePolyhedra.copyCacheValue(source.minY, sourceIndex, this.minY, destinationIndex);
        SpherePolyhedra.copyCacheValue(source.maxY, sourceIndex, this.maxY, destinationIndex);
        SpherePolyhedra.copyCacheValue(source.minZ, sourceIndex, this.minZ, destinationIndex);
        SpherePolyhedra.copyCacheValue(source.maxZ, sourceIndex, this.maxZ, destinationIndex);
        SpherePolyhedra.copyCacheValue(source.containingSphereRadius, sourceIndex, this.containingSphereRadius, destinationIndex);
        SpherePolyhedra.copyCacheValue(source.volume, sourceIndex, this.volume, destinationIndex);
    }

    private void checkSpherePolyhedronIndex(int k) {
        if (k < 0 || k >= this.numberOfSpherePolyhedra) {
            throw new IndexOutOfBoundsException("Index of sphere-polyhedron " + k + " is out of range 0.." + (this.numberOfSpherePolyhedra - 1));
        }
    }

    private void checkSpherePolyhedrionIndex(int spherePolyhedrionIndex) {
        if (spherePolyhedrionIndex < 0 || spherePolyhedrionIndex >= this.numberOfObjects) {
            throw new IndexOutOfBoundsException("Index of sphere-polyhedrion " + spherePolyhedrionIndex + " is out of range 0.." + (this.numberOfObjects - 1));
        }
    }

    private void checkSpherePolyhedrionIndexRange(int from, int to) {
        if (from < 0) {
            throw new IndexOutOfBoundsException("Sphere-polyhedrion \"from\" index " + from + " < 0");
        }
        if (to > this.numberOfObjects) {
            throw new IndexOutOfBoundsException("Sphere-polyhedrion \"to\" index " + to + " > " + this.numberOfObjects + " = number of sphere-polyhedrions");
        }
        if (from > to) {
            throw new IndexOutOfBoundsException("Negative number of sphere-polyhedrions: \"from\" = " + from + " > \"to\" = " + to);
        }
    }

    private static void copyCacheValue(double[] source, int sourceIndex, double[] destination, int destinationIndex) {
        if (destinationIndex < destination.length) {
            destination[destinationIndex] = sourceIndex < source.length ? source[sourceIndex] : Double.NaN;
        }
    }

    private static int increaseCapacity(long required, long existing, int maxAllowed, String objectsName) {
        long result = Math.max(16L, Math.max(required, Math.min((long)maxAllowed, (long)((double)existing * 1.5))));
        if (result > (long)maxAllowed) {
            throw new TooLargeArrayException("Too large array required for building array of sphere-polyhedra: cannot allocate " + result + " >= " + maxAllowed + " " + objectsName);
        }
        return (int)result;
    }

    private static double[] expandWithNaN(double[] original, int newLength) {
        if (newLength <= original.length) {
            return original;
        }
        double[] copy = new double[newLength];
        System.arraycopy(original, 0, copy, 0, original.length);
        Arrays.fill(copy, original.length, copy.length, Double.NaN);
        return copy;
    }

    public static interface RemovingCondition {
        public boolean acceptRemoving(int var1, SpherePolyhedrion var2);

        public boolean requiresObjectForDecision();
    }
}

