/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.kinds.restrictions;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import net.algart.model3d.spherepolyhedra.kinds.SpherePolyhedronKind;
import net.algart.model3d.spherepolyhedra.kinds.restrictions.NeighbourKindProhibition;
import net.algart.model3d.spherepolyhedra.kinds.restrictions.PackingRestriction;
import net.algart.model3d.spherepolyhedra.kinds.restrictions.SpherePolyhedraNeighbourhoodPackingRestriction;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrion;

public final class NeighbourKindSetProhibition
extends SpherePolyhedraNeighbourhoodPackingRestriction {
    private Set<Long> prohibitedNeighbourKindSet = new LinkedHashSet<Long>();
    private int maximalNumberOfProhibitedNeighbours = 0;

    public Set<Long> getProhibitedNeighbourKindSet() {
        return Collections.unmodifiableSet(this.prohibitedNeighbourKindSet);
    }

    public NeighbourKindSetProhibition setProhibitedNeighbourKindSet(Collection<Long> prohibitedNeighbourKindSet) {
        Objects.requireNonNull(prohibitedNeighbourKindSet, "Null prohibitedNeighbourKindSet");
        this.prohibitedNeighbourKindSet = new LinkedHashSet<Long>(prohibitedNeighbourKindSet);
        return this;
    }

    public int getMaximalNumberOfProhibitedNeighbours() {
        return this.maximalNumberOfProhibitedNeighbours;
    }

    public NeighbourKindSetProhibition setMaximalNumberOfProhibitedNeighbours(int maximalNumberOfProhibitedNeighbours) {
        if (maximalNumberOfProhibitedNeighbours < 0 || maximalNumberOfProhibitedNeighbours > 3) {
            throw new IllegalArgumentException("Illegal maximal number of prohibited neighbours " + maximalNumberOfProhibitedNeighbours + " (must be in 0..3 range)");
        }
        this.maximalNumberOfProhibitedNeighbours = maximalNumberOfProhibitedNeighbours;
        return this;
    }

    @Override
    public boolean allowFirstNeighbour(int indexOfNewlyPackedObject, SpherePolyhedrion newlyPackedObject, int neighbourIndex, long neighbourKindId) {
        return this.maximalNumberOfProhibitedNeighbours <= 0 || this.prohibitedNeighbourKindSet.contains(neighbourKindId);
    }

    @Override
    public boolean allowAllNeighbours(int indexOfNewlyPackedObject, SpherePolyhedrion newlyPackedObject, int neighbourIndex1, long neighbourKindId1, int neighbourIndex2, long neighbourKindId2, int neighbourIndex3, long neighbourKindId3) {
        int count;
        if (this.maximalNumberOfProhibitedNeighbours >= 3) {
            return true;
        }
        int n = count = this.prohibitedNeighbourKindSet.contains(neighbourKindId1) ? 1 : 0;
        if (count > this.maximalNumberOfProhibitedNeighbours) {
            return false;
        }
        if (this.prohibitedNeighbourKindSet.contains(neighbourKindId2) && ++count > this.maximalNumberOfProhibitedNeighbours) {
            return false;
        }
        return !this.prohibitedNeighbourKindSet.contains(neighbourKindId3) || ++count <= this.maximalNumberOfProhibitedNeighbours;
    }

    @Override
    public String toString() {
        return "prohibit >" + this.maximalNumberOfProhibitedNeighbours + " neighbours of " + this.prohibitedNeighbourKindSet.size() + " kinds";
    }

    @Override
    protected void toJsonImplementation(JsonObjectBuilder builder) {
        super.toJsonImplementation(builder);
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        for (Long kindId : this.prohibitedNeighbourKindSet) {
            if (kindId == null) continue;
            arrayBuilder.add(SpherePolyhedronKind.idToFriendlyString(kindId));
        }
        builder.add("kinds", (JsonValue)arrayBuilder.build());
        builder.add("number", this.maximalNumberOfProhibitedNeighbours);
    }

    @Override
    protected void fromJsonImplementation(JsonObject json) {
        super.fromJsonImplementation(json);
        JsonArray kindsJson = json.getJsonArray("kinds");
        ArrayList<Long> kinds = new ArrayList<Long>();
        if (kindsJson != null) {
            int n = kindsJson.size();
            for (int k = 0; k < n; ++k) {
                kinds.add(SpherePolyhedronKind.friendlyStringToId(kindsJson.getString(k)));
            }
        }
        this.setProhibitedNeighbourKindSet(kinds);
        this.setMaximalNumberOfProhibitedNeighbours(json.getInt("number", 0));
    }

    @Override
    PackingRestriction optimize() {
        switch (this.prohibitedNeighbourKindSet.size()) {
            case 0: {
                return NONE;
            }
            case 1: {
                return new NeighbourKindProhibition().setMaximalNumberOfProhibitedNeighbours(this.maximalNumberOfProhibitedNeighbours).setProhibitedNeighbourKindId(this.prohibitedNeighbourKindSet.iterator().next());
            }
        }
        return this;
    }
}

