/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.kinds.restrictions;

import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import net.algart.model3d.spherepolyhedra.kinds.restrictions.PackingRestriction;
import net.algart.model3d.spherepolyhedra.kinds.restrictions.SpherePolyhedraNeighbourhoodPackingRestriction;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrion;

public final class NeighbourIndexRequirement
extends SpherePolyhedraNeighbourhoodPackingRestriction {
    private int requiredNeighbourIndex = -1;

    public int getRequiredNeighbourIndex() {
        return this.requiredNeighbourIndex;
    }

    public NeighbourIndexRequirement setRequiredNeighbourIndex(int requiredNeighbourIndex) {
        this.requiredNeighbourIndex = requiredNeighbourIndex;
        return this;
    }

    @Override
    public boolean allowFirstNeighbour(int indexOfNewlyPackedObject, SpherePolyhedrion newlyPackedObject, int neighbourIndex, long neighbourKindId) {
        return this.requiredNeighbourIndex >= 0 && neighbourIndex == this.requiredNeighbourIndex;
    }

    @Override
    public boolean allowAllNeighbours(int indexOfNewlyPackedObject, SpherePolyhedrion newlyPackedObject, int neighbourIndex1, long neighbourKindId1, int neighbourIndex2, long neighbourKindId2, int neighbourIndex3, long neighbourKindId3) {
        return this.allowFirstNeighbour(indexOfNewlyPackedObject, newlyPackedObject, neighbourIndex1, neighbourKindId1);
    }

    @Override
    public String toString() {
        return "require neighbour #" + this.requiredNeighbourIndex;
    }

    @Override
    protected void toJsonImplementation(JsonObjectBuilder builder) {
        super.toJsonImplementation(builder);
        if (this.requiredNeighbourIndex >= 0) {
            builder.add("index", this.requiredNeighbourIndex);
        }
    }

    @Override
    protected void fromJsonImplementation(JsonObject json) {
        super.fromJsonImplementation(json);
        this.setRequiredNeighbourIndex(json.getInt("index", -1));
    }

    @Override
    PackingRestriction optimize() {
        if (this.requiredNeighbourIndex < 0) {
            return NONE;
        }
        return super.optimize();
    }
}

