/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.kinds;

import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.util.Random;
import net.algart.json.Jsons;
import net.algart.model3d.spherepolyhedra.kinds.KindWithRadius;
import net.algart.model3d.spherepolyhedra.kinds.KindWithRandomDistribution;
import net.algart.model3d.spherepolyhedra.objects.GeneratrixSet;
import net.algart.model3d.spherepolyhedra.objects.GeneratrixSphere;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrion;

public final class SphereKind
extends KindWithRandomDistribution
implements KindWithRadius {
    private double r = 1.0;
    private double dr = 0.0;

    @Override
    public double getR() {
        return this.r;
    }

    @Override
    public KindWithRadius setR(double r) {
        this.r = SphereKind.positive(r, "r");
        return this;
    }

    @Override
    public double getDr() {
        return this.dr;
    }

    @Override
    public KindWithRadius setDr(double dr) {
        this.dr = SphereKind.nonNegative(dr, "dr");
        return this;
    }

    @Override
    public SpherePolyhedrion newSpherePolyhedrion(Random random) {
        GeneratrixSphere sphere = GeneratrixSphere.newSphere(this.nextPositive(random, this.r, this.dr));
        return SpherePolyhedrion.ofSingle(GeneratrixSet.newInstance(sphere).toSpherePolyhedron(this.getId()));
    }

    @Override
    public double newSpherePolyhedrionSummaryVolume(Random random) {
        double r = this.nextPositive(random, this.r, this.dr);
        return 1.3333333333333333 * r * Math.PI * r * r;
    }

    @Override
    protected void toJsonImplementation(JsonObjectBuilder builder) {
        super.toJsonImplementation(builder);
        builder.add("r", this.r);
        builder.add("dr", this.dr);
    }

    @Override
    protected void fromJsonImplementation(JsonObject json) {
        super.fromJsonImplementation(json);
        this.setR(Jsons.getDouble((JsonObject)json, (String)"r", (double)1.0));
        this.setDr(Jsons.getDouble((JsonObject)json, (String)"dr", (double)0.0));
    }
}

