/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.kinds;

import java.util.Objects;
import java.util.Random;
import net.algart.math.geometry.Orthonormal3DBasis;
import net.algart.model3d.spherepolyhedra.kinds.KindWithDirectionsAndSizeAndRadius;
import net.algart.model3d.spherepolyhedra.objects.GeneratrixSegment;
import net.algart.model3d.spherepolyhedra.objects.GeneratrixSet;
import net.algart.model3d.spherepolyhedra.objects.GeneratrixSphere;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrion;

public final class SphereCylinderKind
extends KindWithDirectionsAndSizeAndRadius {
    @Override
    public SpherePolyhedrion newSpherePolyhedrion(Random random) {
        Objects.requireNonNull(random, "Null random generator");
        Orthonormal3DBasis basis = this.directions.newRandomBasisAlongDirection(0, random);
        GeneratrixSphere sphere = GeneratrixSphere.newSphere(this.nextPositive(random, this.r, this.dr));
        GeneratrixSegment segment = GeneratrixSegment.newSegmentAlongI(basis, this.nextNonNegative(random, this.a, this.da));
        return SpherePolyhedrion.ofSingle(GeneratrixSet.newInstance(sphere, segment).toSpherePolyhedron(this.getId()));
    }

    @Override
    public double newSpherePolyhedrionSummaryVolume(Random random) {
        double r = this.nextPositive(random, this.r, this.dr);
        double a = this.nextNonNegative(random, this.a, this.da);
        return (1.3333333333333333 * r + a) * Math.PI * r * r;
    }
}

