/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.kinds;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.random.RandomGenerator;
import java.util.stream.Collectors;
import net.algart.json.Jsons;
import net.algart.math.geometry.Orthonormal3DBasis;
import net.algart.model3d.spherepolyhedra.kinds.PreferredDirection;

public final class PreferredDirections
implements Cloneable {
    private PreferredDirection[] directions = new PreferredDirection[0];

    public PreferredDirection[] getDirections() {
        return (PreferredDirection[])this.directions.clone();
    }

    public PreferredDirections setDirections(PreferredDirection ... directions) {
        return this.setDirections(Arrays.asList(directions));
    }

    public PreferredDirections setDirections(Collection<PreferredDirection> directions) {
        int count = 0;
        for (PreferredDirection direction : directions) {
            if (direction == null) continue;
            ++count;
        }
        this.directions = new PreferredDirection[count];
        count = 0;
        for (PreferredDirection direction : directions) {
            if (direction == null) continue;
            this.directions[count++] = direction;
        }
        return this;
    }

    public int numberOfDirections() {
        return this.directions.length;
    }

    public PreferredDirection direction(int index) {
        return index < this.directions.length ? this.directions[index] : null;
    }

    public Orthonormal3DBasis newRandomBasisAlongDirection(int index, Random random) {
        Objects.requireNonNull(random, "Null random generator");
        return index < this.directions.length ? this.directions[index].newRandomBasisAlongDirection(random) : Orthonormal3DBasis.newRandomBasis((RandomGenerator)random);
    }

    public Orthonormal3DBasis newRandomBasisForTwoDirections(Random random) {
        Orthonormal3DBasis basis = this.newRandomBasisAlongDirection(0, random);
        if (this.directions.length >= 2) {
            basis = Orthonormal3DBasis.newBasis((double)basis.ix(), (double)basis.iy(), (double)basis.iz(), (double)this.directions[1].getNormalX(), (double)this.directions[1].getNormalY(), (double)this.directions[1].getNormalZ(), (boolean)false);
        }
        return basis;
    }

    public final JsonArray toJsonArray() {
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        for (PreferredDirection direction : this.directions) {
            arrayBuilder.add((JsonValue)direction.toJson());
        }
        return arrayBuilder.build();
    }

    public PreferredDirections setToJson(JsonArray directionsJsons) {
        return this.setToJson(Jsons.toJsonObjects((JsonArray)directionsJsons));
    }

    public PreferredDirections setToJson(List<JsonObject> directionsJsons) {
        Objects.requireNonNull(directionsJsons, "Null directionsJsons");
        this.setDirections(directionsJsons.stream().map(directionJson -> new PreferredDirection().setToJson((JsonObject)directionJson)).collect(Collectors.toList()));
        return this;
    }

    public PreferredDirections clone() {
        return new PreferredDirections().setDirections(this.directions);
    }
}

