/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.geometries;

import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.util.Random;
import java.util.random.RandomGenerator;
import net.algart.json.Jsons;
import net.algart.math.geometry.Orthonormal3DBasis;
import net.algart.math.geometry.StraightLine3D;
import net.algart.model3d.spherepolyhedra.geometries.SpherePolyhedraPackingGeometry;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedra;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrion;

public final class SphericalHeap
extends SpherePolyhedraPackingGeometry {
    private double centerX = 0.0;
    private double centerY = 0.0;
    private double centerZ = 0.0;

    public double getCenterX() {
        return this.centerX;
    }

    public SphericalHeap setCenterX(double centerX) {
        this.centerX = centerX;
        return this;
    }

    public double getCenterY() {
        return this.centerY;
    }

    public SphericalHeap setCenterY(double centerY) {
        this.centerY = centerY;
        return this;
    }

    public double getCenterZ() {
        return this.centerZ;
    }

    public SphericalHeap setCenterZ(double centerZ) {
        this.centerZ = centerZ;
        return this;
    }

    @Override
    public boolean canBePackedAfterParallelShift(SpherePolyhedrion objectToPack) {
        return true;
    }

    @Override
    public boolean isPositionAllowed(SpherePolyhedrion newlyPackedObject) {
        return true;
    }

    @Override
    public boolean randomPackingDirection(StraightLine3D result, SpherePolyhedrion objectToPack, Random random) {
        result.setStart(this.centerX, this.centerY, this.centerZ).setRandomDirection((RandomGenerator)random);
        return true;
    }

    @Override
    public void buildInitialSpherePolyhedra(SpherePolyhedra spherePolyhedra) {
        spherePolyhedra.clear();
    }

    @Override
    public int numberOfInitialSpherePolyhedra() {
        return 0;
    }

    @Override
    public int numberOfInitialSpherePolyhedrions() {
        return 0;
    }

    @Override
    public int comparePositions(double thisX, double thisY, double thisZ, double thatX, double thatY, double thatZ) {
        return Double.compare(Orthonormal3DBasis.lengthSquare((double)thisX, (double)thisY, (double)thisZ), Orthonormal3DBasis.lengthSquare((double)thatX, (double)thatY, (double)thatZ));
    }

    @Override
    public SpherePolyhedrion packFirst(SpherePolyhedrion objectToPack) {
        return objectToPack.moveTo(this.centerX, this.centerY, this.centerZ);
    }

    @Override
    protected void toJsonImplementation(JsonObjectBuilder builder) {
        super.toJsonImplementation(builder);
        builder.add("centerX", this.centerX);
        builder.add("centerY", this.centerY);
        builder.add("centerZ", this.centerZ);
    }

    @Override
    protected void fromJsonImplementation(JsonObject json) {
        super.fromJsonImplementation(json);
        this.setCenterX(Jsons.getDouble((JsonObject)json, (String)"centerX", (double)0.0));
        this.setCenterY(Jsons.getDouble((JsonObject)json, (String)"centerY", (double)0.0));
        this.setCenterZ(Jsons.getDouble((JsonObject)json, (String)"centerZ", (double)0.0));
    }
}

