/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.geometries;

import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.algart.json.Jsons;
import net.algart.math.geometry.StraightLine3D;
import net.algart.model3d.spherepolyhedra.geometries.SphericalHeap;
import net.algart.model3d.spherepolyhedra.geometries.VerticalRectangularBox;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedra;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrion;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrionPositionComparator;

public abstract class SpherePolyhedraPackingGeometry
implements SpherePolyhedrionPositionComparator {
    public static final String APP_NAME = "sphere-polyhedra-packing-geometry";
    public static final String GEOMETRY_JSON_PROPERTY = "geometry";
    private static final Map<String, Class<? extends SpherePolyhedraPackingGeometry>> KNOWN_GEOMETRIES = Collections.synchronizedMap(new LinkedHashMap());
    private String geometryName = null;
    private volatile Double maxInitialSpherePolyhedraContainingSphereRadius = null;

    public static SpherePolyhedraPackingGeometry of(JsonObject json) {
        SpherePolyhedraPackingGeometry geometry;
        if (!APP_NAME.equals(json.getString("app", null))) {
            throw new JsonException("JSON is not a packing geometry for sphere-polyhedra: no \"app\": \"sphere-polyhedra-packing-geometry\" element");
        }
        String geometryName = Jsons.reqString((JsonObject)json, (String)GEOMETRY_JSON_PROPERTY);
        Class<? extends SpherePolyhedraPackingGeometry> geometryClass = KNOWN_GEOMETRIES.get(geometryName);
        Jsons.requireNonNull(geometryClass, (JsonObject)json, (String)GEOMETRY_JSON_PROPERTY, (String)("unknown \"" + geometryName + "\""), null);
        try {
            geometry = geometryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new JsonException("Cannot create geometry for " + String.valueOf(geometryClass), (Throwable)e);
        }
        geometry.fromJsonImplementation(json);
        return geometry;
    }

    public abstract boolean canBePackedAfterParallelShift(SpherePolyhedrion var1);

    public abstract boolean isPositionAllowed(SpherePolyhedrion var1);

    public abstract boolean randomPackingDirection(StraightLine3D var1, SpherePolyhedrion var2, Random var3);

    public abstract void buildInitialSpherePolyhedra(SpherePolyhedra var1);

    public abstract int numberOfInitialSpherePolyhedra();

    public abstract int numberOfInitialSpherePolyhedrions();

    @Override
    public abstract int comparePositions(double var1, double var3, double var5, double var7, double var9, double var11);

    public abstract SpherePolyhedrion packFirst(SpherePolyhedrion var1);

    public double maxInitialSpherePolyhedraContainingSphereRadius() {
        Double maxRadius = this.maxInitialSpherePolyhedraContainingSphereRadius;
        if (maxRadius == null) {
            this.maxInitialSpherePolyhedraContainingSphereRadius = maxRadius = Double.valueOf(this.findMaxInitialSpherePolyhedraContainingSphereRadius());
        }
        return maxRadius;
    }

    public void clearCache() {
        this.maxInitialSpherePolyhedraContainingSphereRadius = null;
    }

    public final JsonObject toJson() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.toJsonImplementation(builder);
        return builder.build();
    }

    public final String toJsonString() {
        return Jsons.toPrettyString((JsonObject)this.toJson());
    }

    public void setToJson(JsonObject json) {
        Objects.requireNonNull(json, "Null json");
        this.fromJsonImplementation(json);
        this.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String geometryName() {
        Map<String, Class<? extends SpherePolyhedraPackingGeometry>> map = KNOWN_GEOMETRIES;
        synchronized (map) {
            if (this.geometryName != null) {
                return this.geometryName;
            }
            for (Map.Entry<String, Class<? extends SpherePolyhedraPackingGeometry>> entry : KNOWN_GEOMETRIES.entrySet()) {
                if (!this.getClass().equals(entry.getValue())) continue;
                this.geometryName = entry.getKey();
                return this.geometryName;
            }
        }
        throw new IllegalStateException(String.valueOf(this.getClass()) + " has no registered geometry name: you must register it by registerGeometry method");
    }

    protected void toJsonImplementation(JsonObjectBuilder builder) {
        builder.add("app", APP_NAME);
        builder.add(GEOMETRY_JSON_PROPERTY, this.geometryName());
    }

    protected void fromJsonImplementation(JsonObject json) {
    }

    private static void registerGeometry(String simpleName, Class<? extends SpherePolyhedraPackingGeometry> geometryClass) {
        Objects.requireNonNull(simpleName, "Null simple name");
        Objects.requireNonNull(geometryClass, "Null geometry class");
        KNOWN_GEOMETRIES.put(simpleName, geometryClass);
    }

    private double findMaxInitialSpherePolyhedraContainingSphereRadius() {
        double max = 0.0;
        SpherePolyhedra spherePolyhedra = SpherePolyhedra.newEmpty();
        this.buildInitialSpherePolyhedra(spherePolyhedra);
        int n = spherePolyhedra.numberOfSpherePolyhedra();
        for (int k = 0; k < n; ++k) {
            double r = spherePolyhedra.containingSphereRadius(k);
            if (!(r > max)) continue;
            max = r;
        }
        return max;
    }

    static double greaterThan(double value, double min, String valueName) {
        if (value <= min) {
            throw new IllegalArgumentException("Too small " + valueName + " = " + value + " <= " + min);
        }
        return value;
    }

    static double nonNegative(double value, String valueName) {
        if (value < 0.0) {
            throw new IllegalArgumentException("Negative " + valueName + " = " + value + " (it is prohibited)");
        }
        return value;
    }

    static long nonPositive(long value, String valueName) {
        if (value > 0L) {
            throw new IllegalArgumentException("Positive " + valueName + " = " + value + " (it is prohibited)");
        }
        return value;
    }

    static {
        SpherePolyhedraPackingGeometry.registerGeometry("spherical-heap", SphericalHeap.class);
        SpherePolyhedraPackingGeometry.registerGeometry("vertical-box", VerticalRectangularBox.class);
    }
}

