/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.model3d.spherepolyhedra.packing;

import java.util.Objects;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

class SimpleFormula {
    private final ScriptEngine context;
    private final String formula;
    private final Double doubleValue;
    private final CompiledScript compiledFormula;

    SimpleFormula(ScriptEngine context, String formula) {
        this.context = Objects.requireNonNull(context);
        this.formula = Objects.requireNonNull(formula);
        Double doubleValue = null;
        try {
            doubleValue = Double.parseDouble(formula);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.doubleValue = doubleValue;
        try {
            this.compiledFormula = doubleValue == null && context instanceof Compilable ? ((Compilable)((Object)context)).compile(formula) : null;
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException("Cannot evaluate JavaScript formula \"" + formula + "\"", e);
        }
    }

    public String toString() {
        return "formula: " + this.formula;
    }

    String formula() {
        return this.formula;
    }

    boolean isSimple() {
        return this.doubleValue != null;
    }

    double evalDouble() {
        if (this.doubleValue != null) {
            return this.doubleValue;
        }
        Object eval = this.evalObject();
        if (eval == null) {
            return 0.0;
        }
        return Double.parseDouble(eval.toString());
    }

    int evalInt() {
        if (this.doubleValue != null) {
            return (int)this.doubleValue.doubleValue();
        }
        Object eval = this.evalObject();
        if (eval == null) {
            return 0;
        }
        return Integer.parseInt(eval.toString());
    }

    private Object evalObject() {
        try {
            return this.compiledFormula == null ? this.context.eval(this.formula) : this.compiledFormula.eval();
        }
        catch (ScriptException e) {
            throw new IllegalArgumentException("Cannot evaluate JavaScript formula \"" + this.formula + "\"", e);
        }
    }
}

