/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.model3d.spherepolyhedra.common;

import net.algart.executors.api.ExecutionVisibleResultsInformation;
import net.algart.executors.api.Previewable;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.Data;
import net.algart.executors.api.data.Port;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.model3d.spherepolyhedra.common.SpherePolyhedraExecutor;

public abstract class SpherePolyhedraGenerator
extends SpherePolyhedraExecutor
implements ReadOnlyExecutionInput,
Previewable {
    protected SpherePolyhedraGenerator() {
        this(true);
    }

    protected SpherePolyhedraGenerator(boolean addKindSet) {
        this.setDefaultOutputNumbers("xyzr");
        this.addOutputNumbers("generatrix_sets");
        this.addOutputNumbers("kinds");
        this.addOutputNumbers("containing_object_indexes");
        this.addOutputNumbers("first_sphere_polyhedron_indexes");
        this.addOutputScalar("number_of_objects");
        if (addKindSet) {
            this.addOutputScalar("kind_set");
        }
    }

    public Data createPreview() {
        SNumbers xyzr = this.getNumbers("xyzr");
        if (xyzr.isInitialized()) {
            return new SScalar(xyzr.n() + " sphere-polyhedra");
        }
        return null;
    }

    public ExecutionVisibleResultsInformation visibleResultsInformation() {
        if (this.isVisibleResultDisabled()) {
            return new ExecutionVisibleResultsInformation();
        }
        return new ExecutionVisibleResultsInformation().setModel("spherepolyhedra").setPorts(new Port[]{this.getOutputPort("xyzr"), this.getOutputPort("generatrix_sets"), this.getOutputPort("kinds"), this.getOutputPort("kind_set")});
    }

    public boolean isVisiblePort(Port port) {
        return port.isOutput() && (port.getName().equals("xyzr") || port.getName().equals("generatrix_sets") || port.getName().equals("kinds") || port.getName().equals("kind_set"));
    }
}

